/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.LogDataSubmissionTask;
import com.wavefront.agent.data.QueueingReason;
import com.wavefront.agent.data.TaskResult;
import com.wavefront.agent.handlers.AbstractSenderTask;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.LogAPI;
import com.wavefront.dto.Log;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public class LogSenderTask
extends AbstractSenderTask<Log> {
    private final LogAPI logAPI;
    private final UUID proxyId;
    private final TaskQueue<LogDataSubmissionTask> backlog;

    LogSenderTask(HandlerKey handlerKey, LogAPI logAPI, UUID proxyId, int threadId, EntityProperties properties, ScheduledExecutorService scheduler, TaskQueue<LogDataSubmissionTask> backlog) {
        super(handlerKey, threadId, properties, scheduler);
        this.logAPI = logAPI;
        this.proxyId = proxyId;
        this.backlog = backlog;
    }

    @Override
    TaskResult processSingleBatch(List<Log> batch) {
        LogDataSubmissionTask task = new LogDataSubmissionTask(this.logAPI, this.proxyId, this.properties, this.backlog, this.handlerKey.getHandle(), batch, null);
        return task.execute();
    }

    @Override
    public void flushSingleBatch(List<Log> batch, @Nullable QueueingReason reason) {
        LogDataSubmissionTask task = new LogDataSubmissionTask(this.logAPI, this.proxyId, this.properties, this.backlog, this.handlerKey.getHandle(), batch, null);
        task.enqueue(reason);
    }

    @Override
    protected int getDataSize(List<Log> batch) {
        int size = 0;
        for (Log l : batch) {
            size += l.getDataSize();
        }
        return size;
    }

    @Override
    protected int getBlockSize(List<Log> datum, int rateLimit, int batchSize) {
        int maxDataSize = Math.min(rateLimit, batchSize);
        int size = 0;
        for (int i = 0; i < datum.size(); ++i) {
            if ((size += datum.get(i).getDataSize()) <= maxDataSize) continue;
            return i;
        }
        return datum.size();
    }

    @Override
    protected int getObjectSize(Log object) {
        return object.getDataSize();
    }
}

