/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.LineDelimitedDataSubmissionTask;
import com.wavefront.agent.data.QueueingReason;
import com.wavefront.agent.data.TaskResult;
import com.wavefront.agent.handlers.AbstractSenderTask;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.agent.queueing.TaskSizeEstimator;
import com.wavefront.api.ProxyV2API;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

class LineDelimitedSenderTask
extends AbstractSenderTask<String> {
    private final ProxyV2API proxyAPI;
    private final UUID proxyId;
    private final String pushFormat;
    private final TaskSizeEstimator taskSizeEstimator;
    private final TaskQueue<LineDelimitedDataSubmissionTask> backlog;

    LineDelimitedSenderTask(HandlerKey handlerKey, String pushFormat, ProxyV2API proxyAPI, UUID proxyId, EntityProperties properties, ScheduledExecutorService scheduler, int threadId, @Nullable TaskSizeEstimator taskSizeEstimator, TaskQueue<LineDelimitedDataSubmissionTask> backlog) {
        super(handlerKey, threadId, properties, scheduler);
        this.pushFormat = pushFormat;
        this.proxyId = proxyId;
        this.proxyAPI = proxyAPI;
        this.taskSizeEstimator = taskSizeEstimator;
        this.backlog = backlog;
    }

    @Override
    TaskResult processSingleBatch(List<String> batch) {
        LineDelimitedDataSubmissionTask task = new LineDelimitedDataSubmissionTask(this.proxyAPI, this.proxyId, this.properties, this.backlog, this.pushFormat, this.handlerKey.getEntityType(), this.handlerKey.getHandle(), batch, null);
        if (this.taskSizeEstimator != null) {
            this.taskSizeEstimator.scheduleTaskForSizing(task);
        }
        return task.execute();
    }

    @Override
    void flushSingleBatch(List<String> batch, @Nullable QueueingReason reason) {
        LineDelimitedDataSubmissionTask task = new LineDelimitedDataSubmissionTask(this.proxyAPI, this.proxyId, this.properties, this.backlog, this.pushFormat, this.handlerKey.getEntityType(), this.handlerKey.getHandle(), batch, null);
        task.enqueue(reason);
    }
}

