/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.handlers;

import com.wavefront.data.ReportableEntityType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HandlerKey {
    private final ReportableEntityType entityType;
    @Nonnull
    private final String handle;
    @Nullable
    private final String tenantName;

    private HandlerKey(ReportableEntityType entityType, @Nonnull String handle, @Nullable String tenantName) {
        this.entityType = entityType;
        this.handle = handle;
        this.tenantName = tenantName;
    }

    public static String generateTenantSpecificHandle(String handle, @Nonnull String tenantName) {
        return handle + "." + tenantName;
    }

    public ReportableEntityType getEntityType() {
        return this.entityType;
    }

    @Nonnull
    public String getHandle() {
        return this.handle + (this.tenantName == null ? "" : "." + this.tenantName);
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public static HandlerKey of(ReportableEntityType entityType, @Nonnull String handle) {
        return new HandlerKey(entityType, handle, null);
    }

    public static HandlerKey of(ReportableEntityType entityType, @Nonnull String handle, @Nonnull String tenantName) {
        return new HandlerKey(entityType, handle, tenantName);
    }

    public int hashCode() {
        return 961 * this.entityType.hashCode() + 31 * this.handle.hashCode() + (this.tenantName == null ? 0 : this.tenantName.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerKey that = (HandlerKey)o;
        if (!this.entityType.equals((Object)that.entityType)) {
            return false;
        }
        if (!Objects.equals(this.handle, that.handle)) {
            return false;
        }
        return Objects.equals(this.tenantName, that.tenantName);
    }

    public String toString() {
        return this.entityType + "." + this.handle + (this.tenantName == null ? "" : "." + this.tenantName);
    }
}

