/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.formatter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.wavefront.common.MetricMangler;
import java.util.concurrent.atomic.AtomicLong;

public class GraphiteFormatter
implements Function<String, String> {
    private final MetricMangler metricMangler;
    private final AtomicLong ops = new AtomicLong();

    public GraphiteFormatter(String strFields, String strDelimiters, String strFieldsToRemove) {
        Preconditions.checkNotNull((Object)strFields, (Object)"strFields must be defined");
        Preconditions.checkNotNull((Object)strDelimiters, (Object)"strFields must be defined");
        this.metricMangler = new MetricMangler(strFields, strDelimiters, strFieldsToRemove);
    }

    public long getOps() {
        return this.ops.get();
    }

    public MetricMangler getMetricMangler() {
        return this.metricMangler;
    }

    public String apply(String mesg) {
        int index;
        StringBuilder finalMesg = new StringBuilder();
        String[] regions = mesg.trim().split(" ");
        MetricMangler.MetricComponents components = this.metricMangler.extractComponents(regions[0]);
        finalMesg.append(components.metric);
        finalMesg.append(" ");
        for (index = 1; index < regions.length; ++index) {
            finalMesg.append(regions[index]);
            finalMesg.append(" ");
        }
        if (components.source != null) {
            finalMesg.append("source=");
            finalMesg.append(components.source);
        }
        if (components.annotations != null) {
            for (index = 0; index < components.annotations.length; ++index) {
                finalMesg.append(" ");
                finalMesg.append(components.annotations[index]);
            }
        }
        this.ops.incrementAndGet();
        return finalMesg.toString();
    }
}

