/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.wavefront.agent.data.AbstractDataSubmissionTask;
import com.wavefront.agent.data.DataSubmissionException;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.IgnoreStatusCodeException;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.SourceTagAPI;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.dto.SourceTag;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="__CLASS")
public class SourceTagSubmissionTask
extends AbstractDataSubmissionTask<SourceTagSubmissionTask> {
    private transient SourceTagAPI api;
    @JsonProperty
    private SourceTag sourceTag;

    SourceTagSubmissionTask() {
    }

    public SourceTagSubmissionTask(SourceTagAPI api, EntityProperties properties, TaskQueue<SourceTagSubmissionTask> backlog, String handle, @Nonnull SourceTag sourceTag, @Nullable Supplier<Long> timeProvider) {
        super(properties, backlog, handle, ReportableEntityType.SOURCE_TAG, timeProvider);
        this.api = api;
        this.sourceTag = sourceTag;
        this.limitRetries = true;
    }

    @Override
    @Nullable
    Response doExecute() throws DataSubmissionException {
        switch (this.sourceTag.getOperation()) {
            case SOURCE_DESCRIPTION: {
                switch (this.sourceTag.getAction()) {
                    case DELETE: {
                        Response resp = this.api.removeDescription(this.sourceTag.getSource());
                        if (resp.getStatus() == 404) {
                            throw new IgnoreStatusCodeException("Attempting to delete description for a non-existent source  " + this.sourceTag.getSource() + ", ignoring");
                        }
                        return resp;
                    }
                    case SAVE: 
                    case ADD: {
                        return this.api.setDescription(this.sourceTag.getSource(), (String)this.sourceTag.getAnnotations().get(0));
                    }
                }
                throw new IllegalArgumentException("Invalid acton: " + this.sourceTag.getAction());
            }
            case SOURCE_TAG: {
                switch (this.sourceTag.getAction()) {
                    case ADD: {
                        return this.api.appendTag(this.sourceTag.getSource(), (String)this.sourceTag.getAnnotations().get(0));
                    }
                    case DELETE: {
                        String tag = (String)this.sourceTag.getAnnotations().get(0);
                        Response resp = this.api.removeTag(this.sourceTag.getSource(), tag);
                        if (resp.getStatus() == 404) {
                            throw new IgnoreStatusCodeException("Attempting to delete non-existing tag " + tag + " for source " + this.sourceTag.getSource() + ", ignoring");
                        }
                        return resp;
                    }
                    case SAVE: {
                        return this.api.setTags(this.sourceTag.getSource(), this.sourceTag.getAnnotations());
                    }
                }
                throw new IllegalArgumentException("Invalid acton: " + this.sourceTag.getAction());
            }
        }
        throw new IllegalArgumentException("Invalid source tag operation: " + this.sourceTag.getOperation());
    }

    public SourceTag payload() {
        return this.sourceTag;
    }

    @Override
    public int weight() {
        return 1;
    }

    @Override
    public List<SourceTagSubmissionTask> splitTask(int minSplitSize, int maxSplitSize) {
        return ImmutableList.of((Object)this);
    }

    public void injectMembers(SourceTagAPI api, EntityProperties properties, TaskQueue<SourceTagSubmissionTask> backlog) {
        this.api = api;
        this.properties = properties;
        this.backlog = backlog;
        this.timeProvider = System::currentTimeMillis;
    }
}

