/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.wavefront.agent.data.AbstractDataSubmissionTask;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.queueing.TaskQueue;
import com.wavefront.api.EventAPI;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.dto.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="__CLASS")
public class EventDataSubmissionTask
extends AbstractDataSubmissionTask<EventDataSubmissionTask> {
    private transient EventAPI api;
    private transient UUID proxyId;
    @JsonProperty
    private List<Event> events;

    EventDataSubmissionTask() {
    }

    public EventDataSubmissionTask(EventAPI api, UUID proxyId, EntityProperties properties, TaskQueue<EventDataSubmissionTask> backlog, String handle, @Nonnull List<Event> events, @Nullable Supplier<Long> timeProvider) {
        super(properties, backlog, handle, ReportableEntityType.EVENT, timeProvider);
        this.api = api;
        this.proxyId = proxyId;
        this.events = new ArrayList<Event>(events);
    }

    @Override
    public Response doExecute() {
        return this.api.proxyEvents(this.proxyId, this.events);
    }

    @Override
    public List<EventDataSubmissionTask> splitTask(int minSplitSize, int maxSplitSize) {
        if (this.events.size() > Math.max(1, minSplitSize)) {
            ArrayList<EventDataSubmissionTask> result = new ArrayList<EventDataSubmissionTask>();
            int stride = Math.min(maxSplitSize, (int)Math.ceil((double)this.events.size() / 2.0));
            int endingIndex = 0;
            int startingIndex = 0;
            while (endingIndex < this.events.size() - 1) {
                endingIndex = Math.min(this.events.size(), startingIndex + stride) - 1;
                result.add(new EventDataSubmissionTask(this.api, this.proxyId, this.properties, this.backlog, this.handle, this.events.subList(startingIndex, endingIndex + 1), this.timeProvider));
                startingIndex += stride;
            }
            return result;
        }
        return ImmutableList.of((Object)this);
    }

    public List<Event> payload() {
        return this.events;
    }

    @Override
    public int weight() {
        return this.events.size();
    }

    public void injectMembers(EventAPI api, UUID proxyId, EntityProperties properties, TaskQueue<EventDataSubmissionTask> backlog) {
        this.api = api;
        this.proxyId = proxyId;
        this.properties = properties;
        this.backlog = backlog;
        this.timeProvider = System::currentTimeMillis;
    }
}

