/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.RecyclableRateLimiter;
import com.google.common.util.concurrent.RecyclableRateLimiterImpl;
import com.google.common.util.concurrent.RecyclableRateLimiterWithMetrics;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.config.ReportableConfig;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.EntityPropertiesFactory;
import com.wavefront.agent.data.GlobalProperties;
import com.wavefront.agent.data.GlobalPropertiesImpl;
import com.wavefront.agent.data.TaskQueueLevel;
import com.wavefront.data.ReportableEntityType;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class EntityPropertiesFactoryImpl
implements EntityPropertiesFactory {
    private final Map<ReportableEntityType, EntityProperties> wrappers;
    private final GlobalProperties global;

    public EntityPropertiesFactoryImpl(ProxyConfig proxyConfig) {
        this.global = new GlobalPropertiesImpl(proxyConfig);
        PointsProperties pointProperties = new PointsProperties(proxyConfig);
        this.wrappers = ImmutableMap.builder().put((Object)ReportableEntityType.POINT, (Object)pointProperties).put((Object)ReportableEntityType.DELTA_COUNTER, (Object)pointProperties).put((Object)ReportableEntityType.HISTOGRAM, (Object)new HistogramsProperties(proxyConfig)).put((Object)ReportableEntityType.SOURCE_TAG, (Object)new SourceTagsProperties(proxyConfig)).put((Object)ReportableEntityType.TRACE, (Object)new SpansProperties(proxyConfig)).put((Object)ReportableEntityType.TRACE_SPAN_LOGS, (Object)new SpanLogsProperties(proxyConfig)).put((Object)ReportableEntityType.EVENT, (Object)new EventsProperties(proxyConfig)).put((Object)ReportableEntityType.LOGS, (Object)new LogsProperties(proxyConfig)).build();
    }

    @Override
    public EntityProperties get(ReportableEntityType entityType) {
        return this.wrappers.get(entityType);
    }

    @Override
    public GlobalProperties getGlobalProperties() {
        return this.global;
    }

    private static final class LogsProperties
    extends SubscriptionBasedEntityProperties {
        public LogsProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxLogs");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimitLogs");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter.logs";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxLogs();
        }

        @Override
        public int getMemoryBufferLimit() {
            return this.wrapped.getPushMemoryBufferLimitLogs();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimitLogs();
        }

        @Override
        public int getFlushThreads() {
            return this.wrapped.getFlushThreadsLogs();
        }

        @Override
        public int getPushFlushInterval() {
            return this.wrapped.getPushFlushIntervalLogs();
        }
    }

    private static final class EventsProperties
    extends CoreEntityProperties {
        public EventsProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxEvents");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimitEvents");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter.events";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxEvents();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimitEvents();
        }

        @Override
        public int getMemoryBufferLimit() {
            return 16 * this.wrapped.getPushFlushMaxEvents();
        }

        @Override
        public int getFlushThreads() {
            return this.wrapped.getFlushThreadsEvents();
        }
    }

    private static final class SpanLogsProperties
    extends SubscriptionBasedEntityProperties {
        public SpanLogsProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxSpanLogs");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimit");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter.spanLogs";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxSpanLogs();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimitSpanLogs();
        }
    }

    private static final class SpansProperties
    extends SubscriptionBasedEntityProperties {
        public SpansProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxSpans");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimit");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter.spans";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxSpans();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimitSpans();
        }
    }

    private static final class SourceTagsProperties
    extends CoreEntityProperties {
        public SourceTagsProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxSourceTags");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimitSourceTags");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter.sourceTags";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxSourceTags();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimitSourceTags();
        }

        @Override
        public int getMemoryBufferLimit() {
            return 16 * this.wrapped.getPushFlushMaxSourceTags();
        }

        @Override
        public int getFlushThreads() {
            return this.wrapped.getFlushThreadsSourceTags();
        }
    }

    private static final class HistogramsProperties
    extends SubscriptionBasedEntityProperties {
        public HistogramsProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxHistograms");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimit");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter.histograms";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxHistograms();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimitHistograms();
        }
    }

    private static final class PointsProperties
    extends CoreEntityProperties {
        public PointsProperties(ProxyConfig wrapped) {
            super(wrapped);
            ReportableConfig.reportSettingAsGauge(this::getDataPerBatch, "dynamic.pushFlushMaxPoints");
            ReportableConfig.reportSettingAsGauge(this::getMemoryBufferLimit, "dynamic.pushMemoryBufferLimit");
        }

        @Override
        protected String getRateLimiterName() {
            return "limiter";
        }

        @Override
        public int getDataPerBatchOriginal() {
            return this.wrapped.getPushFlushMaxPoints();
        }

        @Override
        public double getRateLimit() {
            return this.wrapped.getPushRateLimit();
        }
    }

    private static abstract class SubscriptionBasedEntityProperties
    extends AbstractEntityProperties {
        private boolean featureDisabled = false;

        public SubscriptionBasedEntityProperties(ProxyConfig wrapped) {
            super(wrapped);
        }

        @Override
        public boolean isFeatureDisabled() {
            return this.featureDisabled;
        }

        @Override
        public void setFeatureDisabled(boolean featureDisabledFlag) {
            this.featureDisabled = featureDisabledFlag;
        }
    }

    private static abstract class CoreEntityProperties
    extends AbstractEntityProperties {
        public CoreEntityProperties(ProxyConfig wrapped) {
            super(wrapped);
        }

        @Override
        public boolean isFeatureDisabled() {
            return false;
        }

        @Override
        public void setFeatureDisabled(boolean featureDisabledFlag) {
            throw new UnsupportedOperationException("Can't disable this feature");
        }
    }

    private static abstract class AbstractEntityProperties
    implements EntityProperties {
        private Integer dataPerBatch = null;
        protected final ProxyConfig wrapped;
        private final RecyclableRateLimiter rateLimiter;
        private final LoadingCache<String, AtomicInteger> backlogSizeCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(x -> new AtomicInteger());
        private final LoadingCache<String, AtomicLong> receivedRateCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build(x -> new AtomicLong());

        public AbstractEntityProperties(ProxyConfig wrapped) {
            this.wrapped = wrapped;
            this.rateLimiter = this.getRateLimit() > 0.0 ? new RecyclableRateLimiterWithMetrics(RecyclableRateLimiterImpl.create((double)this.getRateLimit(), (double)this.getRateLimitMaxBurstSeconds()), this.getRateLimiterName()) : null;
            ReportableConfig.reportSettingAsGauge(this::getPushFlushInterval, "dynamic.pushFlushInterval");
        }

        @Override
        public int getDataPerBatch() {
            return (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{this.dataPerBatch, this.getDataPerBatchOriginal()});
        }

        @Override
        public void setDataPerBatch(@Nullable Integer dataPerBatch) {
            this.dataPerBatch = dataPerBatch;
        }

        @Override
        public boolean isSplitPushWhenRateLimited() {
            return this.wrapped.isSplitPushWhenRateLimited();
        }

        @Override
        public int getRateLimitMaxBurstSeconds() {
            return this.wrapped.getPushRateLimitMaxBurstSeconds();
        }

        @Override
        public RecyclableRateLimiter getRateLimiter() {
            return this.rateLimiter;
        }

        protected abstract String getRateLimiterName();

        @Override
        public int getFlushThreads() {
            return this.wrapped.getFlushThreads();
        }

        @Override
        public int getPushFlushInterval() {
            return this.wrapped.getPushFlushInterval();
        }

        @Override
        public int getMinBatchSplitSize() {
            return 100;
        }

        @Override
        public int getMemoryBufferLimit() {
            return this.wrapped.getPushMemoryBufferLimit();
        }

        @Override
        public TaskQueueLevel getTaskQueueLevel() {
            return this.wrapped.getTaskQueueLevel();
        }

        @Override
        public int getTotalBacklogSize() {
            return this.backlogSizeCache.asMap().values().stream().mapToInt(AtomicInteger::get).sum();
        }

        @Override
        public void reportBacklogSize(String handle, int backlogSize) {
            ((AtomicInteger)this.backlogSizeCache.get((Object)handle)).set(backlogSize);
        }

        @Override
        public long getTotalReceivedRate() {
            return this.receivedRateCache.asMap().values().stream().mapToLong(AtomicLong::get).sum();
        }

        @Override
        public void reportReceivedRate(String handle, long receivedRate) {
            ((AtomicLong)this.receivedRateCache.get((Object)handle)).set(receivedRate);
        }
    }
}

