/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.config;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class ReportableConfig
extends Properties {
    private static final Logger logger = Logger.getLogger(ReportableConfig.class.getCanonicalName());

    public ReportableConfig(String fileName) throws IOException {
        this.load(new FileInputStream(fileName));
    }

    public ReportableConfig() {
    }

    public String getRawProperty(String key, String defaultValue) {
        return this.getProperty(key, defaultValue);
    }

    public int getInteger(String key, Number defaultValue) {
        return this.getNumber(key, defaultValue).intValue();
    }

    public long getLong(String key, Number defaultValue) {
        return this.getNumber(key, defaultValue).longValue();
    }

    public double getDouble(String key, Number defaultValue) {
        return this.getNumber(key, defaultValue).doubleValue();
    }

    public Number getNumber(String key, Number defaultValue) {
        return this.getNumber(key, defaultValue, null, null);
    }

    public Number getNumber(String key, @Nullable Number defaultValue, @Nullable Number clampMinValue, @Nullable Number clampMaxValue) {
        double d;
        String property = this.getProperty(key);
        if (property == null && defaultValue == null) {
            return null;
        }
        try {
            d = property == null ? defaultValue.doubleValue() : Double.parseDouble(property.trim());
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Config setting \"" + key + "\": invalid number format \"" + property + "\"");
        }
        if (clampMinValue != null && d < (double)clampMinValue.longValue()) {
            logger.log(Level.WARNING, key + " (" + d + ") is less than " + clampMinValue + ", will default to " + clampMinValue);
            return clampMinValue;
        }
        if (clampMaxValue != null && d > (double)clampMaxValue.longValue()) {
            logger.log(Level.WARNING, key + " (" + d + ") is greater than " + clampMaxValue + ", will default to " + clampMaxValue);
            return clampMaxValue;
        }
        return d;
    }

    public String getString(String key, String defaultValue) {
        return this.getString(key, defaultValue, null);
    }

    public String getString(String key, String defaultValue, @Nullable Function<String, String> converter) {
        String s = this.getProperty(key, defaultValue);
        return s;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean b = Boolean.parseBoolean(this.getProperty(key, String.valueOf(defaultValue)).trim());
        return b;
    }

    public Boolean isDefined(String key) {
        return this.getProperty(key) != null;
    }

    public static void reportSettingAsGauge(Supplier<Number> numberSupplier, String key) {
        ReportableConfig.reportGauge(numberSupplier, new MetricName("config", "", key));
    }

    public static void reportGauge(final Supplier<Number> numberSupplier, MetricName metricName) {
        Metrics.newGauge((MetricName)metricName, (Gauge)new Gauge<Double>(){

            public Double value() {
                return ((Number)numberSupplier.get()).doubleValue();
            }
        });
    }

    public static void reportGauge(final Number number, MetricName metricName) {
        Metrics.newGauge((MetricName)metricName, (Gauge)new Gauge<Double>(){

            public Double value() {
                return number.doubleValue();
            }
        });
    }
}

