/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.wavefront.agent.config.Configuration;
import com.wavefront.agent.config.ConfigurationException;
import com.wavefront.agent.logsharvesting.LogsMessage;
import com.wavefront.data.Validation;
import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.Match;
import io.thekraken.grok.api.exception.GrokException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import wavefront.report.TimeSeries;

public class MetricMatcher
extends Configuration {
    protected static final Logger logger = Logger.getLogger(MetricMatcher.class.getCanonicalName());
    private final Object grokLock = new Object();
    @JsonProperty
    private String pattern = "";
    @JsonProperty
    private String metricName = "";
    @JsonProperty
    private String hostName = "";
    @JsonProperty
    private List<String> tagKeys = ImmutableList.of();
    @Deprecated
    @JsonProperty
    private List<String> tagValueLabels = ImmutableList.of();
    @JsonProperty
    private List<String> tagValues = ImmutableList.of();
    @JsonProperty
    private String valueLabel = "value";
    private Grok grok = null;
    private Map<String, String> additionalPatterns = Maps.newHashMap();

    public String getValueLabel() {
        return this.valueLabel;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setAdditionalPatterns(Map<String, String> additionalPatterns) {
        this.additionalPatterns = additionalPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grok grok() {
        if (this.grok != null) {
            return this.grok;
        }
        Object object = this.grokLock;
        synchronized (object) {
            if (this.grok != null) {
                return this.grok;
            }
            try {
                this.grok = new Grok();
                InputStream patternStream = this.getClass().getClassLoader().getResourceAsStream("patterns/patterns");
                if (patternStream != null) {
                    this.grok.addPatternFromReader((Reader)new InputStreamReader(patternStream));
                }
                this.additionalPatterns.forEach((key, value) -> {
                    try {
                        this.grok.addPattern(key, value);
                    }
                    catch (GrokException e) {
                        logger.severe("Invalid grok pattern: " + this.pattern);
                        throw new RuntimeException(e);
                    }
                });
                this.grok.compile(this.pattern);
            }
            catch (GrokException e) {
                logger.severe("Invalid grok pattern: " + this.pattern);
                throw new RuntimeException(e);
            }
            return this.grok;
        }
    }

    private static String expandTemplate(String template, Map<String, Object> replacements) {
        if (template.contains("%{")) {
            StringBuffer result = new StringBuffer();
            Matcher placeholders = Pattern.compile("%\\{(.*?)}").matcher(template);
            while (placeholders.find()) {
                if (placeholders.group(1).isEmpty()) {
                    placeholders.appendReplacement(result, placeholders.group(0));
                    continue;
                }
                if (replacements.get(placeholders.group(1)) != null) {
                    placeholders.appendReplacement(result, (String)replacements.get(placeholders.group(1)));
                    continue;
                }
                placeholders.appendReplacement(result, placeholders.group(0));
            }
            placeholders.appendTail(result);
            return result.toString();
        }
        return template;
    }

    public TimeSeries timeSeries(LogsMessage logsMessage, Double[] output) throws NumberFormatException {
        Match match = this.grok().match(logsMessage.getLogLine());
        match.captures();
        if (match.getEnd() == 0) {
            return null;
        }
        Map matches = match.toMap();
        if (output != null) {
            output[0] = matches.containsKey(this.valueLabel) ? Double.valueOf(Double.parseDouble((String)matches.get(this.valueLabel))) : null;
        }
        TimeSeries.Builder builder = TimeSeries.newBuilder();
        String dynamicName = MetricMatcher.expandTemplate(this.metricName, matches);
        String sourceName = StringUtils.isBlank((CharSequence)this.hostName) ? logsMessage.hostOrDefault("parsed-logs") : MetricMatcher.expandTemplate(this.hostName, matches);
        TreeMap tags = Maps.newTreeMap();
        for (int i = 0; i < this.tagKeys.size(); ++i) {
            String tagKey = this.tagKeys.get(i);
            if (this.tagValues.size() > 0) {
                String value = MetricMatcher.expandTemplate(this.tagValues.get(i), matches);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                tags.put(tagKey, value);
                continue;
            }
            String tagValueLabel = this.tagValueLabels.get(i);
            if (!matches.containsKey(tagValueLabel)) {
                logger.severe("Application error: unparsed tag key.");
                continue;
            }
            String value = (String)matches.get(tagValueLabel);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            tags.put(tagKey, value);
        }
        builder.setAnnotations((Map)tags);
        return builder.setMetric(dynamicName).setHost(sourceName).build();
    }

    public boolean hasCapture(String label) {
        return this.grok().getNamedRegexCollection().containsValue(label);
    }

    @Override
    public void verifyAndInit() throws ConfigurationException {
        this.ensure(StringUtils.isNotBlank((CharSequence)this.pattern), "pattern must not be empty.");
        this.ensure(StringUtils.isNotBlank((CharSequence)this.metricName), "metric name must not be empty.");
        String fauxMetricName = this.metricName.replaceAll("%\\{.*\\}", "");
        this.ensure(Validation.charactersAreValid((String)fauxMetricName), "Metric name has illegal characters: " + this.metricName);
        this.ensure(this.tagValues.size() <= 0 || this.tagValueLabels.size() <= 0, "tagValues and tagValueLabels can't be used together");
        this.ensure(this.tagKeys.size() == Math.max(this.tagValueLabels.size(), this.tagValues.size()), "tagKeys and tagValues/tagValueLabels must be parallel arrays.");
    }
}

