/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.wavefront.agent.config.Configuration;
import com.wavefront.agent.config.ConfigurationException;
import com.wavefront.agent.config.MetricMatcher;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LogsIngestionConfig
extends Configuration {
    @JsonProperty
    public Integer aggregationIntervalSeconds = 60;
    @JsonProperty
    public List<MetricMatcher> counters = ImmutableList.of();
    @JsonProperty
    public List<MetricMatcher> gauges = ImmutableList.of();
    @JsonProperty
    public List<MetricMatcher> histograms = ImmutableList.of();
    @JsonProperty
    public List<String> additionalPatterns = ImmutableList.of();
    @JsonProperty
    public long expiryMillis = TimeUnit.HOURS.toMillis(1L);
    @JsonProperty
    public boolean useWavefrontHistograms = false;
    @JsonProperty
    public boolean reportEmptyHistogramStats = true;
    @JsonProperty
    public boolean useDeltaCounters = true;
    @JsonProperty
    public int configReloadIntervalSeconds = 5;

    @Override
    public void verifyAndInit() throws ConfigurationException {
        HashMap additionalPatternMap = Maps.newHashMap();
        for (String pattern : this.additionalPatterns) {
            String[] parts = pattern.split(" ");
            String name = parts[0];
            String regex = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
            additionalPatternMap.put(name, regex);
        }
        this.ensure(this.aggregationIntervalSeconds > 0, "aggregationIntervalSeconds must be positive.");
        for (MetricMatcher p : this.counters) {
            p.setAdditionalPatterns(additionalPatternMap);
            p.verifyAndInit();
        }
        for (MetricMatcher p : this.gauges) {
            p.setAdditionalPatterns(additionalPatternMap);
            p.verifyAndInit();
            this.ensure(p.hasCapture(p.getValueLabel()), "Must have a capture with label '" + p.getValueLabel() + "' for this gauge.");
        }
        for (MetricMatcher p : this.histograms) {
            p.setAdditionalPatterns(additionalPatternMap);
            p.verifyAndInit();
            this.ensure(p.hasCapture(p.getValueLabel()), "Must have a capture with label '" + p.getValueLabel() + "' for this histogram.");
        }
    }
}

