/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import com.google.common.base.Charsets;
import com.wavefront.agent.channel.IncompleteLineDetectingLineBasedFrameDecoder;
import com.wavefront.agent.channel.StatusTrackingHttpObjectAggregator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class PlainTextOrHttpFrameDecoder
extends ByteToMessageDecoder {
    protected static final Logger logger = Logger.getLogger(PlainTextOrHttpFrameDecoder.class.getName());
    private final ChannelHandler handler;
    private final boolean detectGzip;
    @Nullable
    private final CorsConfig corsConfig;
    private final int maxLengthPlaintext;
    private final int maxLengthHttp;
    private static final StringDecoder STRING_DECODER = new StringDecoder(Charsets.UTF_8);
    private static final StringEncoder STRING_ENCODER = new StringEncoder(Charsets.UTF_8);

    public PlainTextOrHttpFrameDecoder(ChannelHandler handler, @Nullable CorsConfig corsConfig, int maxLengthPlaintext, int maxLengthHttp) {
        this(handler, corsConfig, maxLengthPlaintext, maxLengthHttp, true);
    }

    private PlainTextOrHttpFrameDecoder(ChannelHandler handler, @Nullable CorsConfig corsConfig, int maxLengthPlaintext, int maxLengthHttp, boolean detectGzip) {
        this.handler = handler;
        this.corsConfig = corsConfig;
        this.maxLengthPlaintext = maxLengthPlaintext;
        this.maxLengthHttp = maxLengthHttp;
        this.detectGzip = detectGzip;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        if (buffer.readableBytes() < 2) {
            logger.info("Inbound data from " + ctx.channel().remoteAddress() + " has less that 2 readable bytes - ignoring");
            return;
        }
        short firstByte = buffer.getUnsignedByte(buffer.readerIndex());
        short secondByte = buffer.getUnsignedByte(buffer.readerIndex() + 1);
        ChannelPipeline pipeline = ctx.pipeline();
        if (this.detectGzip && PlainTextOrHttpFrameDecoder.isGzip(firstByte, secondByte)) {
            logger.fine("Inbound gzip stream detected");
            pipeline.addLast("gzipdeflater", (ChannelHandler)ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP)).addLast("gzipinflater", (ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)).addLast("unificationB", (ChannelHandler)new PlainTextOrHttpFrameDecoder(this.handler, this.corsConfig, this.maxLengthPlaintext, this.maxLengthHttp, false));
        } else if (PlainTextOrHttpFrameDecoder.isHttp(firstByte, secondByte)) {
            logger.fine("Switching to HTTP protocol");
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder()).addLast("inflater", (ChannelHandler)new HttpContentDecompressor()).addLast("encoder", (ChannelHandler)new HttpResponseEncoder()).addLast("aggregator", (ChannelHandler)new StatusTrackingHttpObjectAggregator(this.maxLengthHttp));
            if (this.corsConfig != null) {
                pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandler(this.corsConfig));
            }
            pipeline.addLast("handler", this.handler);
        } else {
            logger.fine("Switching to plaintext TCP protocol");
            pipeline.addLast("line", (ChannelHandler)new IncompleteLineDetectingLineBasedFrameDecoder(logger::warning, this.maxLengthPlaintext)).addLast("decoder", (ChannelHandler)STRING_DECODER).addLast("encoder", (ChannelHandler)STRING_ENCODER).addLast("handler", this.handler);
        }
        pipeline.remove((ChannelHandler)this);
    }

    private static boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private static boolean isGzip(int magic1, int magic2) {
        return magic1 == 31 && magic2 == 139;
    }
}

