/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import com.wavefront.agent.channel.ChannelUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LineBasedFrameDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class IncompleteLineDetectingLineBasedFrameDecoder
extends LineBasedFrameDecoder {
    private final Consumer<String> warningMessageConsumer;

    IncompleteLineDetectingLineBasedFrameDecoder(@Nonnull Consumer<String> warningMessageConsumer, int maxLength) {
        super(maxLength, true, false);
        this.warningMessageConsumer = warningMessageConsumer;
    }

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        String discardedData;
        super.decodeLast(ctx, in, out);
        int readableBytes = in.readableBytes();
        if (readableBytes > 0 && StringUtils.isNotBlank((CharSequence)(discardedData = in.readBytes(readableBytes).toString(StandardCharsets.UTF_8)))) {
            this.warningMessageConsumer.accept("Client " + ChannelUtils.getRemoteName(ctx) + " disconnected, leaving unterminated string. Input (" + readableBytes + " bytes) discarded: \"" + discardedData + "\"");
        }
    }
}

