/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;

public class HealthCheckManagerImpl
implements HealthCheckManager {
    private static final Logger log = Logger.getLogger(HealthCheckManager.class.getCanonicalName());
    private final Map<Integer, Boolean> statusMap = new HashMap<Integer, Boolean>();
    private final Set<Integer> enabledPorts = new HashSet<Integer>();
    private final String path;
    private final String contentType;
    private final int passStatusCode;
    private final String passResponseBody;
    private final int failStatusCode;
    private final String failResponseBody;

    public HealthCheckManagerImpl(@Nonnull ProxyConfig config) {
        this(config.getHttpHealthCheckPath(), config.getHttpHealthCheckResponseContentType(), config.getHttpHealthCheckPassStatusCode(), config.getHttpHealthCheckPassResponseBody(), config.getHttpHealthCheckFailStatusCode(), config.getHttpHealthCheckFailResponseBody());
    }

    @VisibleForTesting
    HealthCheckManagerImpl(@Nullable String path, @Nullable String contentType, int passStatusCode, @Nullable String passResponseBody, int failStatusCode, @Nullable String failResponseBody) {
        this.path = path;
        this.contentType = contentType;
        this.passStatusCode = passStatusCode;
        this.passResponseBody = (String)ObjectUtils.firstNonNull((Object[])new String[]{passResponseBody, ""});
        this.failStatusCode = failStatusCode;
        this.failResponseBody = (String)ObjectUtils.firstNonNull((Object[])new String[]{failResponseBody, ""});
    }

    @Override
    public HttpResponse getHealthCheckResponse(ChannelHandlerContext ctx, @Nonnull FullHttpRequest request) throws URISyntaxException {
        final int port = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
        if (!this.enabledPorts.contains(port)) {
            return null;
        }
        URI uri = new URI(request.uri());
        if (this.path != null && !this.path.equals(uri.getPath())) {
            return null;
        }
        boolean ok = this.isHealthy(port);
        Metrics.newGauge((MetricName)new TaggedMetricName("listeners", "healthcheck.status", new String[]{"port", String.valueOf(port)}), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return HealthCheckManagerImpl.this.isHealthy(port) ? 1 : 0;
            }
        });
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)(ok ? this.passStatusCode : this.failStatusCode)), Unpooled.copiedBuffer((CharSequence)(ok ? this.passResponseBody : this.failResponseBody), (Charset)CharsetUtil.UTF_8));
        if (this.contentType != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType);
        }
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "healthcheck.httpstatus." + (ok ? this.passStatusCode : this.failStatusCode) + ".count", new String[]{"port", String.valueOf(port)})).inc();
        return response;
    }

    @Override
    public boolean isHealthy(int port) {
        return this.statusMap.getOrDefault(port, true);
    }

    @Override
    public void setHealthy(int port) {
        this.statusMap.put(port, true);
    }

    @Override
    public void setUnhealthy(int port) {
        this.statusMap.put(port, false);
    }

    @Override
    public void setAllHealthy() {
        this.enabledPorts.forEach(x -> {
            this.setHealthy((int)x);
            log.info("Port " + x + " was marked as healthy");
        });
    }

    @Override
    public void setAllUnhealthy() {
        this.enabledPorts.forEach(x -> {
            this.setUnhealthy((int)x);
            log.info("Port " + x + " was marked as unhealthy");
        });
    }

    @Override
    public void enableHealthcheck(int port) {
        this.enabledPorts.add(port);
    }
}

