/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

public class GZIPEncodingInterceptorWithVariableCompression
implements WriterInterceptor {
    private final int level;

    public GZIPEncodingInterceptorWithVariableCompression(int level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            CommittedGZIPOutputStream gzipOutputStream = new CommittedGZIPOutputStream(old, this.level);
            context.getHeaders().remove((Object)"Content-Length");
            context.setOutputStream((OutputStream)((Object)gzipOutputStream));
            try {
                context.proceed();
            }
            finally {
                if (gzipOutputStream.getGzip() != null) {
                    gzipOutputStream.getGzip().finish();
                }
                context.setOutputStream(old);
            }
        } else {
            context.proceed();
        }
    }

    public static class CommittedGZIPOutputStream
    extends CommitHeaderOutputStream {
        private final int level;
        protected GZIPOutputStream gzip;

        protected CommittedGZIPOutputStream(OutputStream delegate, int level) {
            super(delegate, null);
            this.level = level;
        }

        public GZIPOutputStream getGzip() {
            return this.gzip;
        }

        public synchronized void commit() {
            if (this.isHeadersCommitted) {
                return;
            }
            this.isHeadersCommitted = true;
            try {
                this.gzip = new EndableGZIPOutputStream(this.delegate, this.level);
                this.delegate = this.gzip;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        public EndableGZIPOutputStream(OutputStream os, int level) throws IOException {
            super(os);
            this.def.setLevel(level);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

