/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Throwables;
import com.wavefront.agent.SharedMetricsRegistry;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ChannelUtils {
    private static final Map<Integer, LoadingCache<Integer, Counter>> RESPONSE_STATUS_CACHES = new ConcurrentHashMap<Integer, LoadingCache<Integer, Counter>>();

    public static String formatErrorMessage(String message, @Nullable Throwable e, @Nullable ChannelHandlerContext ctx) {
        StringBuilder errMsg = new StringBuilder(message);
        if (ctx != null) {
            errMsg.append("; remote: ");
            errMsg.append(ChannelUtils.getRemoteName(ctx));
        }
        if (e != null) {
            errMsg.append("; ");
            errMsg.append(ChannelUtils.errorMessageWithRootCause(e));
        }
        return errMsg.toString();
    }

    public static void writeHttpResponse(ChannelHandlerContext ctx, HttpResponseStatus status, Object contents, HttpMessage request) {
        ChannelUtils.writeHttpResponse(ctx, status, contents, HttpUtil.isKeepAlive((HttpMessage)request));
    }

    public static void writeHttpResponse(ChannelHandlerContext ctx, HttpResponseStatus status, Object contents, boolean keepAlive) {
        ChannelUtils.writeHttpResponse(ctx, ChannelUtils.makeResponse(status, contents), keepAlive);
    }

    public static void writeHttpResponse(ChannelHandlerContext ctx, HttpResponse response, HttpMessage request) {
        ChannelUtils.writeHttpResponse(ctx, response, HttpUtil.isKeepAlive((HttpMessage)request));
    }

    public static void writeHttpResponse(ChannelHandlerContext ctx, HttpResponse response, boolean keepAlive) {
        ChannelUtils.getHttpStatusCounter(ctx, response.status().code()).inc();
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ctx.write((Object)response);
        } else {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static HttpResponse makeResponse(HttpResponseStatus status, Object contents) {
        DefaultFullHttpResponse response;
        if (contents instanceof JsonNode) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)contents.toString(), (Charset)CharsetUtil.UTF_8));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        } else if (contents instanceof CharSequence) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)((CharSequence)contents), (Charset)CharsetUtil.UTF_8));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
        } else {
            throw new IllegalArgumentException("Unexpected response content type, JsonNode or CharSequence expected: " + contents.getClass().getName());
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }

    public static String errorMessageWithRootCause(@Nonnull Throwable e) {
        StringBuilder msg = new StringBuilder();
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        msg.append("reason: \"");
        msg.append(e.getMessage());
        msg.append("\"");
        if (rootCause != null && rootCause != e && rootCause.getMessage() != null) {
            msg.append(", root cause: \"");
            msg.append(rootCause.getMessage());
            msg.append("\"");
        }
        return msg.toString();
    }

    @Nonnull
    public static String getRemoteName(@Nullable ChannelHandlerContext ctx) {
        if (ctx != null) {
            InetAddress remoteAddress = ChannelUtils.getRemoteAddress(ctx);
            InetSocketAddress localAddress = (InetSocketAddress)ctx.channel().localAddress();
            if (remoteAddress != null && localAddress != null) {
                return remoteAddress.getHostAddress() + " [" + localAddress.getPort() + "]";
            }
        }
        return "";
    }

    public static InetAddress getRemoteAddress(@Nonnull ChannelHandlerContext ctx) {
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return remoteAddress == null ? null : remoteAddress.getAddress();
    }

    public static Counter getHttpStatusCounter(ChannelHandlerContext ctx, int status) {
        InetSocketAddress localAddress;
        if (ctx != null && ctx.channel() != null && (localAddress = (InetSocketAddress)ctx.channel().localAddress()) != null) {
            return (Counter)RESPONSE_STATUS_CACHES.computeIfAbsent(localAddress.getPort(), port -> Caffeine.newBuilder().build(statusCode -> Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "http-requests.status." + statusCode + ".count", new String[]{"port", String.valueOf(port)})))).get((Object)status);
        }
        return SharedMetricsRegistry.getInstance().newCounter(new MetricName("", "", "dummy"));
    }
}

