/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.channel;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CachingHostnameLookupResolver
implements Function<InetAddress, String> {
    private final Function<InetAddress, String> resolverFunc;
    private final LoadingCache<InetAddress, String> rdnsCache;
    private final boolean disableRdnsLookup;

    public CachingHostnameLookupResolver(boolean disableRdnsLookup, @Nullable MetricName metricName) {
        this(disableRdnsLookup, metricName, 5000, Duration.ofMinutes(5L), Duration.ofHours(1L));
    }

    public CachingHostnameLookupResolver(boolean disableRdnsLookup, @Nullable MetricName metricName, int cacheSize, Duration cacheRefreshTtl, Duration cacheExpiryTtl) {
        this(InetAddress::getHostAddress, disableRdnsLookup, metricName, cacheSize, cacheRefreshTtl, cacheExpiryTtl);
    }

    @VisibleForTesting
    CachingHostnameLookupResolver(@Nonnull Function<InetAddress, String> resolverFunc, final boolean disableRdnsLookup, @Nullable MetricName metricName, int cacheSize, Duration cacheRefreshTtl, Duration cacheExpiryTtl) {
        this.resolverFunc = resolverFunc;
        this.disableRdnsLookup = disableRdnsLookup;
        LoadingCache<InetAddress, String> loadingCache = this.rdnsCache = disableRdnsLookup ? null : Caffeine.newBuilder().maximumSize((long)cacheSize).refreshAfterWrite(cacheRefreshTtl).expireAfterAccess(cacheExpiryTtl).build(key -> InetAddress.getByAddress(key.getAddress()).getHostName());
        if (metricName != null) {
            Metrics.newGauge((MetricName)metricName, (Gauge)new Gauge<Long>(){

                public Long value() {
                    return disableRdnsLookup ? 0L : CachingHostnameLookupResolver.this.rdnsCache.estimatedSize();
                }
            });
        }
    }

    @Override
    public String apply(InetAddress addr) {
        return this.disableRdnsLookup ? this.resolverFunc.apply(addr) : (String)this.rdnsCache.get((Object)addr);
    }
}

