/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.auth;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class TokenIntrospectionAuthenticator
implements TokenAuthenticator {
    private static final Logger logger = Logger.getLogger(TokenIntrospectionAuthenticator.class.getCanonicalName());
    private final long authResponseMaxTtlMillis;
    private volatile Long lastSuccessfulCallTs = null;
    private final Counter serviceCalls = Metrics.newCounter((MetricName)new MetricName("auth", "", "api-calls"));
    private final Counter errorCount = Metrics.newCounter((MetricName)new MetricName("auth", "", "api-errors"));
    private final LoadingCache<String, Boolean> tokenValidityCache;

    TokenIntrospectionAuthenticator(int authResponseRefreshInterval, int authResponseMaxTtl, final @Nonnull Supplier<Long> timeSupplier) {
        this.authResponseMaxTtlMillis = TimeUnit.MILLISECONDS.convert(authResponseMaxTtl, TimeUnit.SECONDS);
        this.tokenValidityCache = Caffeine.newBuilder().maximumSize(50000L).refreshAfterWrite((long)Math.min(authResponseRefreshInterval, authResponseMaxTtl), TimeUnit.SECONDS).ticker(() -> (Long)timeSupplier.get() * 1000000L).build((CacheLoader)new CacheLoader<String, Boolean>(){

            public Boolean load(@Nonnull String key) {
                boolean result;
                TokenIntrospectionAuthenticator.this.serviceCalls.inc();
                try {
                    result = TokenIntrospectionAuthenticator.this.callAuthService(key);
                    TokenIntrospectionAuthenticator.this.lastSuccessfulCallTs = (Long)timeSupplier.get();
                }
                catch (Exception e) {
                    TokenIntrospectionAuthenticator.this.errorCount.inc();
                    logger.log(Level.WARNING, "Error during Token Introspection Service call", e);
                    return null;
                }
                return result;
            }

            public Boolean reload(@Nonnull String key, @Nonnull Boolean oldValue) {
                boolean result;
                TokenIntrospectionAuthenticator.this.serviceCalls.inc();
                try {
                    result = TokenIntrospectionAuthenticator.this.callAuthService(key);
                    TokenIntrospectionAuthenticator.this.lastSuccessfulCallTs = (Long)timeSupplier.get();
                }
                catch (Exception e) {
                    TokenIntrospectionAuthenticator.this.errorCount.inc();
                    logger.log(Level.WARNING, "Error during Token Introspection Service call", e);
                    if (TokenIntrospectionAuthenticator.this.lastSuccessfulCallTs != null && (Long)timeSupplier.get() - TokenIntrospectionAuthenticator.this.lastSuccessfulCallTs > TokenIntrospectionAuthenticator.this.authResponseMaxTtlMillis) {
                        return null;
                    }
                    return oldValue;
                }
                return result;
            }
        });
    }

    abstract boolean callAuthService(@Nonnull String var1) throws Exception;

    @Override
    public boolean authorize(@Nullable String token) {
        if (token == null) {
            return false;
        }
        Boolean tokenResult = (Boolean)this.tokenValidityCache.get((Object)token);
        return tokenResult == null ? false : tokenResult;
    }

    @Override
    public boolean authRequired() {
        return true;
    }
}

