/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.auth;

import com.wavefront.agent.auth.DummyAuthenticator;
import com.wavefront.agent.auth.HttpGetTokenIntrospectionAuthenticator;
import com.wavefront.agent.auth.Oauth2TokenIntrospectionAuthenticator;
import com.wavefront.agent.auth.StaticTokenAuthenticator;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.auth.TokenValidationMethod;
import org.apache.http.client.HttpClient;

public class TokenAuthenticatorBuilder {
    private TokenValidationMethod tokenValidationMethod = TokenValidationMethod.NONE;
    private HttpClient httpClient = null;
    private String tokenIntrospectionServiceUrl = null;
    private String tokenIntrospectionAuthorizationHeader = null;
    private int authResponseRefreshInterval = 600;
    private int authResponseMaxTtl = 86400;
    private String staticToken = null;

    public static TokenAuthenticatorBuilder create() {
        return new TokenAuthenticatorBuilder();
    }

    private TokenAuthenticatorBuilder() {
    }

    public TokenAuthenticatorBuilder setTokenValidationMethod(TokenValidationMethod tokenValidationMethod) {
        this.tokenValidationMethod = tokenValidationMethod;
        return this;
    }

    public TokenAuthenticatorBuilder setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public TokenAuthenticatorBuilder setTokenIntrospectionServiceUrl(String tokenIntrospectionServiceUrl) {
        this.tokenIntrospectionServiceUrl = tokenIntrospectionServiceUrl;
        return this;
    }

    public TokenAuthenticatorBuilder setTokenIntrospectionAuthorizationHeader(String tokenIntrospectionAuthorizationHeader) {
        this.tokenIntrospectionAuthorizationHeader = tokenIntrospectionAuthorizationHeader;
        return this;
    }

    public TokenAuthenticatorBuilder setAuthResponseRefreshInterval(int authResponseRefreshInterval) {
        this.authResponseRefreshInterval = authResponseRefreshInterval;
        return this;
    }

    public TokenAuthenticatorBuilder setAuthResponseMaxTtl(int authResponseMaxTtl) {
        this.authResponseMaxTtl = authResponseMaxTtl;
        return this;
    }

    public TokenAuthenticatorBuilder setStaticToken(String staticToken) {
        this.staticToken = staticToken;
        return this;
    }

    public TokenAuthenticator build() {
        switch (this.tokenValidationMethod) {
            case NONE: {
                return new DummyAuthenticator();
            }
            case STATIC_TOKEN: {
                return new StaticTokenAuthenticator(this.staticToken);
            }
            case HTTP_GET: {
                return new HttpGetTokenIntrospectionAuthenticator(this.httpClient, this.tokenIntrospectionServiceUrl, this.tokenIntrospectionAuthorizationHeader, this.authResponseRefreshInterval, this.authResponseMaxTtl);
            }
            case OAUTH2: {
                return new Oauth2TokenIntrospectionAuthenticator(this.httpClient, this.tokenIntrospectionServiceUrl, this.tokenIntrospectionAuthorizationHeader, this.authResponseRefreshInterval, this.authResponseMaxTtl);
            }
        }
        throw new IllegalStateException("Unknown token validation method!");
    }
}

