/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.wavefront.agent.auth.TokenIntrospectionAuthenticator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

class Oauth2TokenIntrospectionAuthenticator
extends TokenIntrospectionAuthenticator {
    private final HttpClient httpClient;
    private final String tokenIntrospectionServiceUrl;
    private final String tokenIntrospectionAuthorizationHeader;
    private final Counter accessGrantedResponses = Metrics.newCounter((MetricName)new MetricName("auth", "", "access-granted"));
    private final Counter accessDeniedResponses = Metrics.newCounter((MetricName)new MetricName("auth", "", "access-denied"));
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();

    Oauth2TokenIntrospectionAuthenticator(@Nonnull HttpClient httpClient, @Nonnull String tokenIntrospectionServiceUrl, @Nullable String tokenIntrospectionAuthorizationHeader, int authResponseRefreshInterval, int authResponseMaxTtl) {
        this(httpClient, tokenIntrospectionServiceUrl, tokenIntrospectionAuthorizationHeader, authResponseRefreshInterval, authResponseMaxTtl, System::currentTimeMillis);
    }

    @VisibleForTesting
    Oauth2TokenIntrospectionAuthenticator(@Nonnull HttpClient httpClient, @Nonnull String tokenIntrospectionServiceUrl, @Nullable String tokenIntrospectionAuthorizationHeader, int authResponseRefreshInterval, int authResponseMaxTtl, @Nonnull Supplier<Long> timeSupplier) {
        super(authResponseRefreshInterval, authResponseMaxTtl, timeSupplier);
        Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient must be set");
        Preconditions.checkNotNull((Object)tokenIntrospectionServiceUrl, (Object)"tokenIntrospectionServiceUrl parameter must be set");
        this.httpClient = httpClient;
        this.tokenIntrospectionServiceUrl = tokenIntrospectionServiceUrl;
        this.tokenIntrospectionAuthorizationHeader = tokenIntrospectionAuthorizationHeader;
    }

    @Override
    boolean callAuthService(@Nonnull String token) throws Exception {
        HttpPost request = new HttpPost(this.tokenIntrospectionServiceUrl.replace("{{token}}", token));
        request.setHeader("Content-Type", "application/x-www-form-urlencoded");
        request.setHeader("Accept", "application/json");
        if (this.tokenIntrospectionAuthorizationHeader != null) {
            request.setHeader("Authorization", this.tokenIntrospectionAuthorizationHeader);
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity((List)ImmutableList.of((Object)new BasicNameValuePair("token", token))));
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        JsonNode node = JSON_PARSER.readTree(EntityUtils.toString((HttpEntity)response.getEntity()));
        if (!node.hasNonNull("active") || !node.get("active").isBoolean()) {
            throw new RuntimeException("Response does not contain 'active' field");
        }
        boolean result = node.get("active").asBoolean();
        if (result) {
            this.accessGrantedResponses.inc();
        } else {
            this.accessDeniedResponses.inc();
        }
        return result;
    }
}

