/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.wavefront.agent.JsonNodeWriter;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.SSLConnectionSocketFactoryImpl;
import com.wavefront.agent.api.NoopEventAPI;
import com.wavefront.agent.api.NoopLogAPI;
import com.wavefront.agent.api.NoopProxyV2API;
import com.wavefront.agent.api.NoopSourceTagAPI;
import com.wavefront.agent.channel.DisableGZIPEncodingInterceptor;
import com.wavefront.agent.channel.GZIPEncodingInterceptorWithVariableCompression;
import com.wavefront.api.EventAPI;
import com.wavefront.api.LogAPI;
import com.wavefront.api.ProxyV2API;
import com.wavefront.api.SourceTagAPI;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.client.jaxrs.internal.LocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.interceptors.encoding.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class APIContainer {
    public static final String CENTRAL_TENANT_NAME = "central";
    public static final String API_SERVER = "server";
    public static final String API_TOKEN = "token";
    private final ProxyConfig proxyConfig;
    private final ResteasyProviderFactory resteasyProviderFactory;
    private final ClientHttpEngine clientHttpEngine;
    private final boolean discardData;
    private Map<String, ProxyV2API> proxyV2APIsForMulticasting;
    private Map<String, SourceTagAPI> sourceTagAPIsForMulticasting;
    private Map<String, EventAPI> eventAPIsForMulticasting;
    private LogAPI logAPI;
    private String logServerToken;
    private String logServerEndpointUrl;
    private static final Logger logger = LogManager.getLogger((String)APIContainer.class.getCanonicalName());

    public APIContainer(ProxyConfig proxyConfig, boolean discardData) {
        this.proxyConfig = proxyConfig;
        this.logServerToken = "NOT_SET";
        this.logServerEndpointUrl = "NOT_SET";
        this.resteasyProviderFactory = this.createProviderFactory();
        this.clientHttpEngine = this.createHttpEngine();
        this.discardData = discardData;
        this.logAPI = this.createService(this.logServerEndpointUrl, LogAPI.class);
        this.proxyV2APIsForMulticasting = Maps.newHashMap();
        this.sourceTagAPIsForMulticasting = Maps.newHashMap();
        this.eventAPIsForMulticasting = Maps.newHashMap();
        for (Map.Entry<String, Map<String, String>> tenantInfo : proxyConfig.getMulticastingTenantList().entrySet()) {
            String tenantName = tenantInfo.getKey();
            String tenantServer = tenantInfo.getValue().get(API_SERVER);
            this.proxyV2APIsForMulticasting.put(tenantName, this.createService(tenantServer, ProxyV2API.class));
            this.sourceTagAPIsForMulticasting.put(tenantName, this.createService(tenantServer, SourceTagAPI.class));
            this.eventAPIsForMulticasting.put(tenantName, this.createService(tenantServer, EventAPI.class));
        }
        if (discardData) {
            ProxyV2API proxyV2API = this.proxyV2APIsForMulticasting.get(CENTRAL_TENANT_NAME);
            this.proxyV2APIsForMulticasting = Maps.newHashMap();
            this.proxyV2APIsForMulticasting.put(CENTRAL_TENANT_NAME, new NoopProxyV2API(proxyV2API));
            this.sourceTagAPIsForMulticasting = Maps.newHashMap();
            this.sourceTagAPIsForMulticasting.put(CENTRAL_TENANT_NAME, new NoopSourceTagAPI());
            this.eventAPIsForMulticasting = Maps.newHashMap();
            this.eventAPIsForMulticasting.put(CENTRAL_TENANT_NAME, new NoopEventAPI());
            this.logAPI = new NoopLogAPI();
        }
        this.configureHttpProxy();
    }

    @VisibleForTesting
    public APIContainer(ProxyV2API proxyV2API, SourceTagAPI sourceTagAPI, EventAPI eventAPI, LogAPI logAPI) {
        this.proxyConfig = null;
        this.resteasyProviderFactory = null;
        this.clientHttpEngine = null;
        this.discardData = false;
        this.logAPI = logAPI;
        this.proxyV2APIsForMulticasting = Maps.newHashMap();
        this.proxyV2APIsForMulticasting.put(CENTRAL_TENANT_NAME, proxyV2API);
        this.sourceTagAPIsForMulticasting = Maps.newHashMap();
        this.sourceTagAPIsForMulticasting.put(CENTRAL_TENANT_NAME, sourceTagAPI);
        this.eventAPIsForMulticasting = Maps.newHashMap();
        this.eventAPIsForMulticasting.put(CENTRAL_TENANT_NAME, eventAPI);
    }

    public Collection<String> getTenantNameList() {
        return this.proxyV2APIsForMulticasting.keySet();
    }

    public ProxyV2API getProxyV2APIForTenant(String tenantName) {
        return this.proxyV2APIsForMulticasting.get(tenantName);
    }

    public SourceTagAPI getSourceTagAPIForTenant(String tenantName) {
        return this.sourceTagAPIsForMulticasting.get(tenantName);
    }

    public EventAPI getEventAPIForTenant(String tenantName) {
        return this.eventAPIsForMulticasting.get(tenantName);
    }

    public LogAPI getLogAPI() {
        return this.logAPI;
    }

    public void updateLogServerEndpointURLandToken(String logServerEndpointUrl, String logServerToken) {
        if (StringUtils.isBlank((String)logServerEndpointUrl) != StringUtils.isBlank((String)logServerToken)) {
            logger.warn("mismatch between logServerEndPointUrl and logServerToken during checkin");
        }
        if (StringUtils.isBlank((String)logServerEndpointUrl) || StringUtils.isBlank((String)logServerToken)) {
            return;
        }
        if (!StringUtils.equals((String)logServerEndpointUrl, (String)this.logServerEndpointUrl) || !StringUtils.equals((String)logServerToken, (String)this.logServerToken)) {
            this.logServerEndpointUrl = logServerEndpointUrl;
            this.logServerToken = logServerToken;
            this.logAPI = this.createService(logServerEndpointUrl, LogAPI.class, this.createProviderFactory());
            if (this.discardData) {
                this.logAPI = new NoopLogAPI();
            }
        }
    }

    public void updateServerEndpointURL(String tenantName, String serverEndpointUrl) {
        if (this.proxyConfig == null) {
            throw new IllegalStateException("Can't invoke updateServerEndpointURL with this constructor");
        }
        this.proxyV2APIsForMulticasting.put(tenantName, this.createService(serverEndpointUrl, ProxyV2API.class));
        this.sourceTagAPIsForMulticasting.put(tenantName, this.createService(serverEndpointUrl, SourceTagAPI.class));
        this.eventAPIsForMulticasting.put(tenantName, this.createService(serverEndpointUrl, EventAPI.class));
        if (this.discardData) {
            ProxyV2API proxyV2API = this.proxyV2APIsForMulticasting.get(CENTRAL_TENANT_NAME);
            this.proxyV2APIsForMulticasting = Maps.newHashMap();
            this.proxyV2APIsForMulticasting.put(CENTRAL_TENANT_NAME, new NoopProxyV2API(proxyV2API));
            this.sourceTagAPIsForMulticasting = Maps.newHashMap();
            this.sourceTagAPIsForMulticasting.put(CENTRAL_TENANT_NAME, new NoopSourceTagAPI());
            this.eventAPIsForMulticasting = Maps.newHashMap();
            this.eventAPIsForMulticasting.put(CENTRAL_TENANT_NAME, new NoopEventAPI());
        }
    }

    private void configureHttpProxy() {
        if (this.proxyConfig.getProxyHost() != null) {
            System.setProperty("http.proxyHost", this.proxyConfig.getProxyHost());
            System.setProperty("https.proxyHost", this.proxyConfig.getProxyHost());
            System.setProperty("http.proxyPort", String.valueOf(this.proxyConfig.getProxyPort()));
            System.setProperty("https.proxyPort", String.valueOf(this.proxyConfig.getProxyPort()));
        }
        if (this.proxyConfig.getProxyUser() != null && this.proxyConfig.getProxyPassword() != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                        return new PasswordAuthentication(APIContainer.this.proxyConfig.getProxyUser(), APIContainer.this.proxyConfig.getProxyPassword().toCharArray());
                    }
                    return null;
                }
            });
        }
    }

    private ResteasyProviderFactory createProviderFactory() {
        LocalResteasyProviderFactory factory = new LocalResteasyProviderFactory(ResteasyProviderFactory.getInstance());
        factory.registerProvider(JsonNodeWriter.class);
        if (!factory.getClasses().contains(ResteasyJackson2Provider.class)) {
            factory.registerProvider(ResteasyJackson2Provider.class);
        }
        factory.register(GZIPDecodingInterceptor.class);
        if (this.proxyConfig.isGzipCompression()) {
            GZIPEncodingInterceptorWithVariableCompression interceptor = new GZIPEncodingInterceptorWithVariableCompression(this.proxyConfig.getGzipCompressionLevel());
            factory.register((Object)interceptor);
        } else {
            factory.register(DisableGZIPEncodingInterceptor.class);
        }
        factory.register(AcceptEncodingGZIPFilter.class);
        factory.register(context -> {
            if ((context.getUri().getPath().contains("/v2/wfproxy") || context.getUri().getPath().contains("/v2/source") || context.getUri().getPath().contains("/event")) && !context.getUri().getPath().endsWith("checkin")) {
                context.getHeaders().add((Object)"Authorization", (Object)("Bearer " + this.proxyConfig.getToken()));
            } else if (context.getUri().getPath().contains("/le-mans")) {
                context.getHeaders().add((Object)"Authorization", (Object)("Bearer " + this.logServerToken));
            }
        });
        return factory;
    }

    private ClientHttpEngine createHttpEngine() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setUserAgent(this.proxyConfig.getHttpUserAgent()).setMaxConnTotal(this.proxyConfig.getHttpMaxConnTotal()).setMaxConnPerRoute(this.proxyConfig.getHttpMaxConnPerRoute()).setConnectionTimeToLive(1L, TimeUnit.MINUTES).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.proxyConfig.getHttpRequestTimeout()).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactoryImpl(SSLConnectionSocketFactory.getSystemSocketFactory(), this.proxyConfig.getHttpRequestTimeout())).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.proxyConfig.getHttpAutoRetries(), true){

            protected boolean handleAsIdempotent(HttpRequest request) {
                return true;
            }
        }).setDefaultRequestConfig(RequestConfig.custom().setContentCompressionEnabled(true).setRedirectsEnabled(true).setConnectTimeout(this.proxyConfig.getHttpConnectTimeout()).setConnectionRequestTimeout(this.proxyConfig.getHttpConnectTimeout()).setSocketTimeout(this.proxyConfig.getHttpRequestTimeout()).build()).build();
        ApacheHttpClient4Engine httpEngine = new ApacheHttpClient4Engine((HttpClient)httpClient, true);
        httpEngine.setFileUploadInMemoryThresholdLimit(100);
        httpEngine.setFileUploadMemoryUnit(ApacheHttpClient4Engine.MemoryUnit.MB);
        return httpEngine;
    }

    private <T> T createService(String serverEndpointUrl, Class<T> apiClass) {
        return this.createServiceInternal(serverEndpointUrl, apiClass, this.resteasyProviderFactory);
    }

    private <T> T createService(String serverEndpointUrl, Class<T> apiClass, ResteasyProviderFactory resteasyProviderFactory) {
        return this.createServiceInternal(serverEndpointUrl, apiClass, resteasyProviderFactory);
    }

    private <T> T createServiceInternal(String serverEndpointUrl, Class<T> apiClass, ResteasyProviderFactory resteasyProviderFactory) {
        ResteasyClient client = new ResteasyClientBuilder().httpEngine(this.clientHttpEngine).providerFactory(resteasyProviderFactory).build();
        ResteasyWebTarget target = client.target(serverEndpointUrl);
        return (T)target.proxy(apiClass);
    }
}

