/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.RecyclableRateLimiter;
import com.tdunning.math.stats.AgentDigest;
import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.handlers.RequestHandler;
import com.uber.tchannel.channels.Connection;
import com.wavefront.agent.AbstractAgent;
import com.wavefront.agent.ProxyMemoryGuard;
import com.wavefront.agent.ProxyUtil;
import com.wavefront.agent.auth.TokenAuthenticator;
import com.wavefront.agent.auth.TokenAuthenticatorBuilder;
import com.wavefront.agent.channel.CachingHostnameLookupResolver;
import com.wavefront.agent.channel.HealthCheckManager;
import com.wavefront.agent.channel.HealthCheckManagerImpl;
import com.wavefront.agent.channel.SharedGraphiteHostAnnotator;
import com.wavefront.agent.config.ConfigurationException;
import com.wavefront.agent.data.EntityProperties;
import com.wavefront.agent.data.EntityPropertiesFactory;
import com.wavefront.agent.data.QueueingReason;
import com.wavefront.agent.formatter.GraphiteFormatter;
import com.wavefront.agent.handlers.DelegatingReportableEntityHandlerFactoryImpl;
import com.wavefront.agent.handlers.DeltaCounterAccumulationHandlerImpl;
import com.wavefront.agent.handlers.HandlerKey;
import com.wavefront.agent.handlers.HistogramAccumulationHandlerImpl;
import com.wavefront.agent.handlers.InternalProxyWavefrontClient;
import com.wavefront.agent.handlers.ReportableEntityHandler;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactory;
import com.wavefront.agent.handlers.ReportableEntityHandlerFactoryImpl;
import com.wavefront.agent.handlers.SenderTaskFactory;
import com.wavefront.agent.handlers.SenderTaskFactoryImpl;
import com.wavefront.agent.handlers.TrafficShapingRateLimitAdjuster;
import com.wavefront.agent.histogram.Granularity;
import com.wavefront.agent.histogram.HistogramKey;
import com.wavefront.agent.histogram.HistogramRecompressor;
import com.wavefront.agent.histogram.HistogramUtils;
import com.wavefront.agent.histogram.MapLoader;
import com.wavefront.agent.histogram.PointHandlerDispatcher;
import com.wavefront.agent.histogram.accumulator.AccumulationCache;
import com.wavefront.agent.histogram.accumulator.AgentDigestFactory;
import com.wavefront.agent.listeners.AdminPortUnificationHandler;
import com.wavefront.agent.listeners.ChannelByteArrayHandler;
import com.wavefront.agent.listeners.DataDogPortUnificationHandler;
import com.wavefront.agent.listeners.HttpHealthCheckEndpointHandler;
import com.wavefront.agent.listeners.JsonMetricsPortUnificationHandler;
import com.wavefront.agent.listeners.OpenTSDBPortUnificationHandler;
import com.wavefront.agent.listeners.RawLogsIngesterPortUnificationHandler;
import com.wavefront.agent.listeners.RelayPortUnificationHandler;
import com.wavefront.agent.listeners.WavefrontPortUnificationHandler;
import com.wavefront.agent.listeners.WriteHttpJsonPortUnificationHandler;
import com.wavefront.agent.listeners.otlp.OtlpGrpcMetricsHandler;
import com.wavefront.agent.listeners.otlp.OtlpGrpcTraceHandler;
import com.wavefront.agent.listeners.otlp.OtlpHttpHandler;
import com.wavefront.agent.listeners.tracing.CustomTracingPortUnificationHandler;
import com.wavefront.agent.listeners.tracing.JaegerGrpcCollectorHandler;
import com.wavefront.agent.listeners.tracing.JaegerPortUnificationHandler;
import com.wavefront.agent.listeners.tracing.JaegerTChannelCollectorHandler;
import com.wavefront.agent.listeners.tracing.TracePortUnificationHandler;
import com.wavefront.agent.listeners.tracing.ZipkinPortUnificationHandler;
import com.wavefront.agent.logsharvesting.FilebeatIngester;
import com.wavefront.agent.logsharvesting.LogsIngester;
import com.wavefront.agent.preprocessor.PreprocessorRuleMetrics;
import com.wavefront.agent.preprocessor.ReportPointAddPrefixTransformer;
import com.wavefront.agent.preprocessor.ReportPointTimestampInRangeFilter;
import com.wavefront.agent.preprocessor.SpanSanitizeTransformer;
import com.wavefront.agent.queueing.QueueingFactory;
import com.wavefront.agent.queueing.QueueingFactoryImpl;
import com.wavefront.agent.queueing.SQSQueueFactoryImpl;
import com.wavefront.agent.queueing.TaskQueueFactory;
import com.wavefront.agent.queueing.TaskQueueFactoryImpl;
import com.wavefront.agent.sampler.SpanSampler;
import com.wavefront.agent.sampler.SpanSamplerUtils;
import com.wavefront.api.agent.AgentConfiguration;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.Utils;
import com.wavefront.data.ReportableEntityType;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.EventDecoder;
import com.wavefront.ingester.HistogramDecoder;
import com.wavefront.ingester.OpenTSDBDecoder;
import com.wavefront.ingester.PickleProtocolDecoder;
import com.wavefront.ingester.ReportLogDecoder;
import com.wavefront.ingester.ReportPointDecoder;
import com.wavefront.ingester.ReportPointDecoderWrapper;
import com.wavefront.ingester.ReportSourceTagDecoder;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.wavefront.ingester.SpanDecoder;
import com.wavefront.ingester.SpanLogsDecoder;
import com.wavefront.ingester.TcpIngester;
import com.wavefront.internal.reporter.WavefrontInternalReporter;
import com.wavefront.metrics.ExpectedAgentMetric;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.entities.tracing.sampling.CompositeSampler;
import com.wavefront.sdk.entities.tracing.sampling.RateSampler;
import com.wavefront.sdk.entities.tracing.sampling.Sampler;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.grpc.BindableService;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.bytes.ByteArrayDecoder;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.net.BindException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.SizedReader;
import net.openhft.chronicle.map.ChronicleMap;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.logstash.beats.Server;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;
import wavefront.report.Span;
import wavefront.report.SpanLogs;

public class PushAgent
extends AbstractAgent {
    protected final Map<Integer, Thread> listeners = new HashMap<Integer, Thread>();
    protected final IdentityHashMap<ChannelOption<?>, Object> childChannelOptions = new IdentityHashMap();
    protected ScheduledExecutorService histogramExecutor;
    protected ScheduledExecutorService histogramFlushExecutor;
    @VisibleForTesting
    protected List<Runnable> histogramFlushRunnables = new ArrayList<Runnable>();
    protected final Counter bindErrors;
    protected TaskQueueFactory taskQueueFactory;
    protected SharedGraphiteHostAnnotator remoteHostAnnotator;
    protected Function<InetAddress, String> hostnameResolver;
    protected SenderTaskFactoryImpl senderTaskFactory;
    protected QueueingFactory queueingFactory;
    protected Function<Histogram, Histogram> histogramRecompressor;
    protected ReportableEntityHandlerFactoryImpl handlerFactory;
    protected ReportableEntityHandlerFactory deltaCounterHandlerFactory;
    protected HealthCheckManager healthCheckManager;
    protected TokenAuthenticator tokenAuthenticator;
    protected final Supplier<Map<ReportableEntityType, ReportableEntityDecoder<?, ?>>> decoderSupplier;
    protected final RateSampler rateSampler;
    private Logger blockedPointsLogger;
    private Logger blockedHistogramsLogger;
    private Logger blockedSpansLogger;
    private Logger blockedLogsLogger;

    public PushAgent() {
        this.bindErrors = Metrics.newCounter((MetricName)ExpectedAgentMetric.LISTENERS_BIND_ERRORS.metricName);
        this.histogramRecompressor = null;
        this.tokenAuthenticator = TokenAuthenticator.DUMMY_AUTHENTICATOR;
        this.decoderSupplier = Utils.lazySupplier(() -> ImmutableMap.builder().put((Object)ReportableEntityType.POINT, (Object)new ReportPointDecoder(() -> "unknown", this.proxyConfig.getCustomSourceTags())).put((Object)ReportableEntityType.SOURCE_TAG, (Object)new ReportSourceTagDecoder()).put((Object)ReportableEntityType.HISTOGRAM, (Object)new ReportPointDecoderWrapper((Decoder)new HistogramDecoder("unknown"))).put((Object)ReportableEntityType.TRACE, (Object)new SpanDecoder("unknown")).put((Object)ReportableEntityType.TRACE_SPAN_LOGS, (Object)new SpanLogsDecoder()).put((Object)ReportableEntityType.EVENT, (Object)new EventDecoder()).put((Object)ReportableEntityType.LOGS, (Object)new ReportLogDecoder(() -> "unknown", this.proxyConfig.getCustomSourceTags(), this.proxyConfig.getCustomTimestampTags(), this.proxyConfig.getCustomMessageTags(), this.proxyConfig.getCustomApplicationTags(), this.proxyConfig.getCustomServiceTags(), this.proxyConfig.getCustomLevelTags(), this.proxyConfig.getCustomExceptionTags())).build());
        this.rateSampler = new RateSampler(1.0);
    }

    public static void main(String[] args) {
        String versionStr = "Wavefront Proxy version " + Utils.getBuildVersion() + " (pkg:" + Utils.getPackage() + "), runtime: " + Utils.getJavaVersion();
        logger.info(versionStr);
        new PushAgent().start(args);
    }

    protected void setupMemoryGuard() {
        if (this.proxyConfig.getMemGuardFlushThreshold() > 0) {
            float threshold = (float)this.proxyConfig.getMemGuardFlushThreshold() / 100.0f;
            new ProxyMemoryGuard(() -> this.senderTaskFactory.drainBuffersToQueue(QueueingReason.MEMORY_PRESSURE), threshold);
        }
    }

    @Override
    protected void startListeners() throws Exception {
        this.blockedPointsLogger = Logger.getLogger(this.proxyConfig.getBlockedPointsLoggerName());
        this.blockedHistogramsLogger = Logger.getLogger(this.proxyConfig.getBlockedHistogramsLoggerName());
        this.blockedSpansLogger = Logger.getLogger(this.proxyConfig.getBlockedSpansLoggerName());
        this.blockedLogsLogger = Logger.getLogger(this.proxyConfig.getBlockedLogsLoggerName());
        if (this.proxyConfig.getSoLingerTime() >= 0) {
            this.childChannelOptions.put(ChannelOption.SO_LINGER, this.proxyConfig.getSoLingerTime());
        }
        this.hostnameResolver = new CachingHostnameLookupResolver(this.proxyConfig.isDisableRdnsLookup(), ExpectedAgentMetric.RDNS_CACHE_SIZE.metricName);
        this.taskQueueFactory = this.proxyConfig.isSqsQueueBuffer() ? new SQSQueueFactoryImpl(this.proxyConfig.getSqsQueueNameTemplate(), this.proxyConfig.getSqsQueueRegion(), this.proxyConfig.getSqsQueueIdentifier(), this.proxyConfig.isPurgeBuffer()) : new TaskQueueFactoryImpl(this.proxyConfig.getBufferFile(), this.proxyConfig.isPurgeBuffer(), this.proxyConfig.isDisableBufferSharding(), this.proxyConfig.getBufferShardSize());
        this.remoteHostAnnotator = new SharedGraphiteHostAnnotator(this.proxyConfig.getCustomSourceTags(), this.hostnameResolver);
        this.queueingFactory = new QueueingFactoryImpl(this.apiContainer, this.agentId, this.taskQueueFactory, this.entityPropertiesFactoryMap);
        this.senderTaskFactory = new SenderTaskFactoryImpl(this.apiContainer, this.agentId, this.taskQueueFactory, this.queueingFactory, this.entityPropertiesFactoryMap);
        if (this.proxyConfig.isHistogramPassthroughRecompression()) {
            this.histogramRecompressor = new HistogramRecompressor(() -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).getGlobalProperties().getHistogramStorageAccuracy());
        }
        this.handlerFactory = new ReportableEntityHandlerFactoryImpl(this.senderTaskFactory, this.proxyConfig.getPushBlockedSamples(), this.validationConfiguration, this.blockedPointsLogger, this.blockedHistogramsLogger, this.blockedSpansLogger, this.histogramRecompressor, this.entityPropertiesFactoryMap, this.blockedLogsLogger);
        if (this.proxyConfig.isTrafficShaping()) {
            new TrafficShapingRateLimitAdjuster(this.entityPropertiesFactoryMap, this.proxyConfig.getTrafficShapingWindowSeconds(), this.proxyConfig.getTrafficShapingHeadroom()).start();
        }
        this.healthCheckManager = new HealthCheckManagerImpl(this.proxyConfig);
        this.tokenAuthenticator = this.configureTokenAuthenticator();
        this.shutdownTasks.add(() -> this.senderTaskFactory.shutdown());
        this.shutdownTasks.add(() -> this.senderTaskFactory.drainBuffersToQueue(null));
        SpanSampler spanSampler = this.createSpanSampler();
        if (this.proxyConfig.getAdminApiListenerPort() > 0) {
            this.startAdminListener(this.proxyConfig.getAdminApiListenerPort());
        }
        Utils.csvToList(this.proxyConfig.getHttpHealthCheckPorts()).forEach(strPort -> this.startHealthCheckListener(Integer.parseInt(strPort)));
        Utils.csvToList(this.proxyConfig.getPushListenerPorts()).forEach(strPort -> {
            this.startGraphiteListener((String)strPort, this.handlerFactory, this.remoteHostAnnotator, spanSampler);
            logger.info("listening on port: " + strPort + " for Wavefront metrics");
        });
        Utils.csvToList(this.proxyConfig.getDeltaCountersAggregationListenerPorts()).forEach(strPort -> {
            this.startDeltaCounterListener((String)strPort, this.remoteHostAnnotator, this.senderTaskFactory, spanSampler);
            logger.info("listening on port: " + strPort + " for Wavefront delta counter metrics");
        });
        this.bootstrapHistograms(spanSampler);
        if (StringUtils.isNotBlank((CharSequence)this.proxyConfig.getGraphitePorts()) || StringUtils.isNotBlank((CharSequence)this.proxyConfig.getPicklePorts())) {
            if (this.tokenAuthenticator.authRequired()) {
                logger.warning("Graphite mode is not compatible with HTTP authentication, ignoring");
            } else {
                Preconditions.checkNotNull((Object)this.proxyConfig.getGraphiteFormat(), (Object)"graphiteFormat must be supplied to enable graphite support");
                Preconditions.checkNotNull((Object)this.proxyConfig.getGraphiteDelimiters(), (Object)"graphiteDelimiters must be supplied to enable graphite support");
                GraphiteFormatter graphiteFormatter = new GraphiteFormatter(this.proxyConfig.getGraphiteFormat(), this.proxyConfig.getGraphiteDelimiters(), this.proxyConfig.getGraphiteFieldsToRemove());
                Utils.csvToList(this.proxyConfig.getGraphitePorts()).forEach(strPort -> {
                    this.preprocessors.getSystemPreprocessor((String)strPort).forPointLine().addTransformer(0, (Function<String, String>)((Object)graphiteFormatter));
                    this.startGraphiteListener((String)strPort, this.handlerFactory, null, spanSampler);
                    logger.info("listening on port: " + strPort + " for graphite metrics");
                });
                Utils.csvToList(this.proxyConfig.getPicklePorts()).forEach(strPort -> this.startPickleListener((String)strPort, this.handlerFactory, graphiteFormatter));
            }
        }
        Utils.csvToList(this.proxyConfig.getOpentsdbPorts()).forEach(strPort -> this.startOpenTsdbListener((String)strPort, this.handlerFactory));
        if (this.proxyConfig.getDataDogJsonPorts() != null) {
            CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setUserAgent(this.proxyConfig.getHttpUserAgent()).setConnectionTimeToLive(1L, TimeUnit.MINUTES).setMaxConnPerRoute(100).setMaxConnTotal(100).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.proxyConfig.getHttpAutoRetries(), true)).setDefaultRequestConfig(RequestConfig.custom().setContentCompressionEnabled(true).setRedirectsEnabled(true).setConnectTimeout(this.proxyConfig.getHttpConnectTimeout()).setConnectionRequestTimeout(this.proxyConfig.getHttpConnectTimeout()).setSocketTimeout(this.proxyConfig.getHttpRequestTimeout()).build()).build();
            Utils.csvToList(this.proxyConfig.getDataDogJsonPorts()).forEach(arg_0 -> this.lambda$startListeners$13((HttpClient)httpClient, arg_0));
        }
        this.startDistributedTracingListeners(spanSampler);
        this.startOtlpListeners(spanSampler);
        Utils.csvToList(this.proxyConfig.getPushRelayListenerPorts()).forEach(strPort -> this.startRelayListener((String)strPort, this.handlerFactory, this.remoteHostAnnotator));
        Utils.csvToList(this.proxyConfig.getJsonListenerPorts()).forEach(strPort -> this.startJsonListener((String)strPort, this.handlerFactory));
        Utils.csvToList(this.proxyConfig.getWriteHttpJsonListenerPorts()).forEach(strPort -> this.startWriteHttpJsonListener((String)strPort, this.handlerFactory));
        if (this.proxyConfig.getFilebeatPort() > 0 || this.proxyConfig.getRawLogsPort() > 0) {
            if (this.loadLogsIngestionConfig() != null) {
                logger.info("Initializing logs ingestion");
                try {
                    LogsIngester logsIngester = new LogsIngester(this.handlerFactory, this::loadLogsIngestionConfig, this.proxyConfig.getPrefix());
                    logsIngester.start();
                    if (this.proxyConfig.getFilebeatPort() > 0) {
                        this.startLogsIngestionListener(this.proxyConfig.getFilebeatPort(), logsIngester);
                    }
                    if (this.proxyConfig.getRawLogsPort() > 0) {
                        this.startRawLogsIngestionListener(this.proxyConfig.getRawLogsPort(), logsIngester);
                    }
                }
                catch (ConfigurationException e) {
                    logger.log(Level.SEVERE, "Cannot start logsIngestion", e);
                }
            } else {
                logger.warning("Cannot start logsIngestion: invalid configuration or no config specified");
            }
        }
        this.setupMemoryGuard();
    }

    private void startDistributedTracingListeners(SpanSampler spanSampler) {
        Utils.csvToList(this.proxyConfig.getTraceListenerPorts()).forEach(strPort -> this.startTraceListener((String)strPort, this.handlerFactory, spanSampler));
        Utils.csvToList(this.proxyConfig.getCustomTracingListenerPorts()).forEach(strPort -> this.startCustomTracingListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler));
        Utils.csvToList(this.proxyConfig.getTraceJaegerListenerPorts()).forEach(strPort -> {
            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("point.spanSanitize", "count", new String[]{"port", strPort})), null, null);
            this.preprocessors.getSystemPreprocessor((String)strPort).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanSanitizeTransformer(ruleMetrics)));
            this.startTraceJaegerListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler);
        });
        Utils.csvToList(this.proxyConfig.getTraceJaegerGrpcListenerPorts()).forEach(strPort -> {
            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("point.spanSanitize", "count", new String[]{"port", strPort})), null, null);
            this.preprocessors.getSystemPreprocessor((String)strPort).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanSanitizeTransformer(ruleMetrics)));
            this.startTraceJaegerGrpcListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler);
        });
        Utils.csvToList(this.proxyConfig.getTraceJaegerHttpListenerPorts()).forEach(strPort -> {
            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("point.spanSanitize", "count", new String[]{"port", strPort})), null, null);
            this.preprocessors.getSystemPreprocessor((String)strPort).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanSanitizeTransformer(ruleMetrics)));
            this.startTraceJaegerHttpListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler);
        });
        Utils.csvToList(this.proxyConfig.getTraceZipkinListenerPorts()).forEach(strPort -> {
            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("point.spanSanitize", "count", new String[]{"port", strPort})), null, null);
            this.preprocessors.getSystemPreprocessor((String)strPort).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanSanitizeTransformer(ruleMetrics)));
            this.startTraceZipkinListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler);
        });
    }

    private void startOtlpListeners(SpanSampler spanSampler) {
        Utils.csvToList(this.proxyConfig.getOtlpGrpcListenerPorts()).forEach(strPort -> {
            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("point.spanSanitize", "count", new String[]{"port", strPort})), null, null);
            this.preprocessors.getSystemPreprocessor((String)strPort).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanSanitizeTransformer(ruleMetrics)));
            this.startOtlpGrpcListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler);
        });
        Utils.csvToList(this.proxyConfig.getOtlpHttpListenerPorts()).forEach(strPort -> {
            PreprocessorRuleMetrics ruleMetrics = new PreprocessorRuleMetrics(Metrics.newCounter((MetricName)new TaggedMetricName("point.spanSanitize", "count", new String[]{"port", strPort})), null, null);
            this.preprocessors.getSystemPreprocessor((String)strPort).forSpan().addTransformer((Function<Span, Span>)((Object)new SpanSanitizeTransformer(ruleMetrics)));
            this.startOtlpHttpListener((String)strPort, this.handlerFactory, new InternalProxyWavefrontClient(this.handlerFactory, (String)strPort), spanSampler);
        });
    }

    private SpanSampler createSpanSampler() {
        this.rateSampler.setSamplingRate(((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).getGlobalProperties().getTraceSamplingRate());
        Sampler durationSampler = SpanSamplerUtils.getDurationSampler(this.proxyConfig.getTraceSamplingDuration());
        List<Sampler> samplers = SpanSamplerUtils.fromSamplers(new Sampler[]{this.rateSampler, durationSampler});
        SpanSampler spanSampler = new SpanSampler((Sampler)new CompositeSampler(samplers), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).getGlobalProperties().getActiveSpanSamplingPolicies());
        return spanSampler;
    }

    private void bootstrapHistograms(SpanSampler spanSampler) throws Exception {
        List<String> histMinPorts = Utils.csvToList(this.proxyConfig.getHistogramMinuteListenerPorts());
        List<String> histHourPorts = Utils.csvToList(this.proxyConfig.getHistogramHourListenerPorts());
        List<String> histDayPorts = Utils.csvToList(this.proxyConfig.getHistogramDayListenerPorts());
        List<String> histDistPorts = Utils.csvToList(this.proxyConfig.getHistogramDistListenerPorts());
        int activeHistogramAggregationTypes = (histDayPorts.size() > 0 ? 1 : 0) + (histHourPorts.size() > 0 ? 1 : 0) + (histMinPorts.size() > 0 ? 1 : 0) + (histDistPorts.size() > 0 ? 1 : 0);
        if (activeHistogramAggregationTypes > 0) {
            this.histogramExecutor = Executors.newScheduledThreadPool(1 + activeHistogramAggregationTypes, (ThreadFactory)new NamedThreadFactory("histogram-service"));
            this.histogramFlushExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() / 2, (ThreadFactory)new NamedThreadFactory("histogram-flush"));
            this.managedExecutors.add(this.histogramExecutor);
            this.managedExecutors.add(this.histogramFlushExecutor);
            File baseDirectory = new File(this.proxyConfig.getHistogramStateDirectory());
            ReportableEntityHandler<ReportPoint, String> pointHandler = this.handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.HISTOGRAM, "histogram_ports"));
            this.startHistogramListeners(histMinPorts, pointHandler, this.remoteHostAnnotator, Granularity.MINUTE, this.proxyConfig.getHistogramMinuteFlushSecs(), this.proxyConfig.isHistogramMinuteMemoryCache(), baseDirectory, this.proxyConfig.getHistogramMinuteAccumulatorSize(), this.proxyConfig.getHistogramMinuteAvgKeyBytes(), this.proxyConfig.getHistogramMinuteAvgDigestBytes(), this.proxyConfig.getHistogramMinuteCompression(), this.proxyConfig.isHistogramMinuteAccumulatorPersisted(), spanSampler);
            this.startHistogramListeners(histHourPorts, pointHandler, this.remoteHostAnnotator, Granularity.HOUR, this.proxyConfig.getHistogramHourFlushSecs(), this.proxyConfig.isHistogramHourMemoryCache(), baseDirectory, this.proxyConfig.getHistogramHourAccumulatorSize(), this.proxyConfig.getHistogramHourAvgKeyBytes(), this.proxyConfig.getHistogramHourAvgDigestBytes(), this.proxyConfig.getHistogramHourCompression(), this.proxyConfig.isHistogramHourAccumulatorPersisted(), spanSampler);
            this.startHistogramListeners(histDayPorts, pointHandler, this.remoteHostAnnotator, Granularity.DAY, this.proxyConfig.getHistogramDayFlushSecs(), this.proxyConfig.isHistogramDayMemoryCache(), baseDirectory, this.proxyConfig.getHistogramDayAccumulatorSize(), this.proxyConfig.getHistogramDayAvgKeyBytes(), this.proxyConfig.getHistogramDayAvgDigestBytes(), this.proxyConfig.getHistogramDayCompression(), this.proxyConfig.isHistogramDayAccumulatorPersisted(), spanSampler);
            this.startHistogramListeners(histDistPorts, pointHandler, this.remoteHostAnnotator, null, this.proxyConfig.getHistogramDistFlushSecs(), this.proxyConfig.isHistogramDistMemoryCache(), baseDirectory, this.proxyConfig.getHistogramDistAccumulatorSize(), this.proxyConfig.getHistogramDistAvgKeyBytes(), this.proxyConfig.getHistogramDistAvgDigestBytes(), this.proxyConfig.getHistogramDistCompression(), this.proxyConfig.isHistogramDistAccumulatorPersisted(), spanSampler);
        }
    }

    @Nullable
    protected SslContext getSslContext(String port) {
        return this.secureAllPorts || this.tlsPorts.contains(port) ? this.sslContext : null;
    }

    @Nullable
    protected CorsConfig getCorsConfig(String port) {
        List<String> ports = this.proxyConfig.getCorsEnabledPorts();
        List<String> corsOrigin = this.proxyConfig.getCorsOrigin();
        if (ports.equals(ImmutableList.of((Object)"*")) || ports.contains(port)) {
            CorsConfigBuilder builder = corsOrigin.equals(ImmutableList.of((Object)"*")) ? CorsConfigBuilder.forOrigin((String)corsOrigin.get(0)) : CorsConfigBuilder.forOrigins((String[])corsOrigin.toArray(new String[0]));
            builder.allowedRequestHeaders(new String[]{"Content-Type", "Referer", "User-Agent"});
            builder.allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT});
            if (this.proxyConfig.isCorsAllowNullOrigin()) {
                builder.allowNullOrigin();
            }
            return builder.build();
        }
        return null;
    }

    protected void startJsonListener(String strPort, ReportableEntityHandlerFactory handlerFactory) {
        int port = Integer.parseInt(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        JsonMetricsPortUnificationHandler channelHandler = new JsonMetricsPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, handlerFactory, this.proxyConfig.getPrefix(), this.proxyConfig.getHostname(), this.preprocessors.get(strPort));
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-plaintext-json-" + port);
        logger.info("listening on port: " + strPort + " for JSON metrics data");
    }

    protected void startWriteHttpJsonListener(String strPort, ReportableEntityHandlerFactory handlerFactory) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        WriteHttpJsonPortUnificationHandler channelHandler = new WriteHttpJsonPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, handlerFactory, this.proxyConfig.getHostname(), this.preprocessors.get(strPort));
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-plaintext-writehttpjson-" + port);
        logger.info("listening on port: " + strPort + " for write_http data");
    }

    protected void startOpenTsdbListener(String strPort, ReportableEntityHandlerFactory handlerFactory) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        ReportPointDecoderWrapper openTSDBDecoder = new ReportPointDecoderWrapper((Decoder)new OpenTSDBDecoder("unknown", this.proxyConfig.getCustomSourceTags()));
        OpenTSDBPortUnificationHandler channelHandler = new OpenTSDBPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, (ReportableEntityDecoder<String, ReportPoint>)openTSDBDecoder, handlerFactory, this.preprocessors.get(strPort), this.hostnameResolver);
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-plaintext-opentsdb-" + port);
        logger.info("listening on port: " + strPort + " for OpenTSDB metrics");
    }

    protected void startDataDogListener(String strPort, ReportableEntityHandlerFactory handlerFactory, HttpClient httpClient) {
        if (this.tokenAuthenticator.authRequired()) {
            logger.warning("Port: " + strPort + " (DataDog) is not compatible with HTTP authentication, ignoring");
            return;
        }
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        DataDogPortUnificationHandler channelHandler = new DataDogPortUnificationHandler(strPort, this.healthCheckManager, handlerFactory, this.proxyConfig.getDataDogRequestRelayAsyncThreads(), this.proxyConfig.isDataDogRequestRelaySyncMode(), this.proxyConfig.isDataDogProcessSystemMetrics(), this.proxyConfig.isDataDogProcessServiceChecks(), httpClient, this.proxyConfig.getDataDogRequestRelayTarget(), this.preprocessors.get(strPort));
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-plaintext-datadog-" + port);
        logger.info("listening on port: " + strPort + " for DataDog metrics");
    }

    protected void startPickleListener(String strPort, ReportableEntityHandlerFactory handlerFactory, GraphiteFormatter formatter) {
        if (this.tokenAuthenticator.authRequired()) {
            logger.warning("Port: " + strPort + " (pickle format) is not compatible with HTTP authentication, ignoring");
            return;
        }
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        ChannelByteArrayHandler channelHandler = new ChannelByteArrayHandler((ReportableEntityDecoder<byte[], ReportPoint>)new PickleProtocolDecoder("unknown", this.proxyConfig.getCustomSourceTags(), formatter.getMetricMangler(), port), handlerFactory.getHandler(HandlerKey.of(ReportableEntityType.POINT, strPort)), this.preprocessors.get(strPort), this.blockedPointsLogger);
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((Iterable<Supplier<ChannelHandler>>)ImmutableList.of(() -> new LengthFieldBasedFrameDecoder(ByteOrder.BIG_ENDIAN, 1000000, 0, 4, 0, 4, false), ByteArrayDecoder::new, () -> PushAgent.lambda$startPickleListener$27((ChannelHandler)channelHandler)), port, this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-binary-pickle-" + strPort);
        logger.info("listening on port: " + strPort + " for Graphite/pickle protocol metrics");
    }

    protected void startTraceListener(String strPort, ReportableEntityHandlerFactory handlerFactory, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        TracePortUnificationHandler channelHandler = new TracePortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, (ReportableEntityDecoder<String, Span>)new SpanDecoder("unknown"), (ReportableEntityDecoder<JsonNode, SpanLogs>)new SpanLogsDecoder(), this.preprocessors.get(strPort), handlerFactory, sampler, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getTraceListenerMaxReceivedLength(), this.proxyConfig.getTraceListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-plaintext-trace-" + port);
        logger.info("listening on port: " + strPort + " for trace data");
    }

    @VisibleForTesting
    protected void startCustomTracingListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        WavefrontInternalReporter wfInternalReporter = null;
        if (wfSender != null) {
            wfInternalReporter = new WavefrontInternalReporter.Builder().prefixedWith("tracing.derived").withSource("custom_tracing").reportMinuteDistribution().build(wfSender);
            wfInternalReporter.start(1L, TimeUnit.MINUTES);
        }
        CustomTracingPortUnificationHandler channelHandler = new CustomTracingPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, (ReportableEntityDecoder<String, Span>)new SpanDecoder("unknown"), (ReportableEntityDecoder<JsonNode, SpanLogs>)new SpanLogsDecoder(), this.preprocessors.get(strPort), handlerFactory, sampler, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), wfSender, wfInternalReporter, this.proxyConfig.getTraceDerivedCustomTagKeys(), this.proxyConfig.getCustomTracingApplicationName(), this.proxyConfig.getCustomTracingServiceName());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getTraceListenerMaxReceivedLength(), this.proxyConfig.getTraceListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-custom-trace-" + port);
        logger.info("listening on port: " + strPort + " for custom trace data");
    }

    protected void startTraceJaegerListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        if (this.tokenAuthenticator.authRequired()) {
            logger.warning("Port: " + strPort + " is not compatible with HTTP authentication, ignoring");
            return;
        }
        this.startAsManagedThread(Integer.parseInt(strPort), () -> {
            this.activeListeners.inc();
            try {
                TChannel server = new TChannel.Builder("jaeger-collector").setServerPort(Integer.parseInt(strPort)).build();
                server.makeSubChannel("jaeger-collector", Connection.Direction.IN).register("Collector::submitBatches", (RequestHandler)new JaegerTChannelCollectorHandler(strPort, handlerFactory, wfSender, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), this.preprocessors.get(strPort), sampler, this.proxyConfig.getTraceJaegerApplicationName(), this.proxyConfig.getTraceDerivedCustomTagKeys()));
                server.listen().channel().closeFuture().sync();
                server.shutdown(false);
            }
            catch (InterruptedException e) {
                logger.info("Listener on port " + strPort + " shut down.");
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Jaeger trace collector exception", e);
            }
            finally {
                this.activeListeners.dec();
            }
        }, "listener-jaeger-tchannel-" + strPort);
        logger.info("listening on port: " + strPort + " for trace data (Jaeger format over TChannel)");
    }

    protected void startTraceJaegerHttpListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        JaegerPortUnificationHandler channelHandler = new JaegerPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, handlerFactory, wfSender, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), this.preprocessors.get(strPort), sampler, this.proxyConfig.getTraceJaegerApplicationName(), this.proxyConfig.getTraceDerivedCustomTagKeys());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getTraceListenerMaxReceivedLength(), this.proxyConfig.getTraceListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-jaeger-http-" + port);
        logger.info("listening on port: " + strPort + " for trace data (Jaeger format over HTTP)");
    }

    protected void startTraceJaegerGrpcListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        if (this.tokenAuthenticator.authRequired()) {
            logger.warning("Port: " + strPort + " is not compatible with HTTP authentication, ignoring");
            return;
        }
        int port = Integer.parseInt(strPort);
        this.startAsManagedThread(port, () -> {
            this.activeListeners.inc();
            try {
                io.grpc.Server server = ((NettyServerBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)new JaegerGrpcCollectorHandler(strPort, handlerFactory, wfSender, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), this.preprocessors.get(strPort), sampler, this.proxyConfig.getTraceJaegerApplicationName(), this.proxyConfig.getTraceDerivedCustomTagKeys()))).build();
                server.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Jaeger gRPC trace collector exception", e);
            }
            finally {
                this.activeListeners.dec();
            }
        }, "listener-jaeger-grpc-" + strPort);
        logger.info("listening on port: " + strPort + " for trace data (Jaeger Protobuf format over gRPC)");
    }

    protected void startOtlpGrpcListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        this.startAsManagedThread(port, () -> {
            this.activeListeners.inc();
            try {
                OtlpGrpcTraceHandler traceHandler = new OtlpGrpcTraceHandler(strPort, handlerFactory, wfSender, this.preprocessors.get(strPort), sampler, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), this.proxyConfig.getHostname(), this.proxyConfig.getTraceDerivedCustomTagKeys());
                OtlpGrpcMetricsHandler metricsHandler = new OtlpGrpcMetricsHandler(strPort, handlerFactory, this.preprocessors.get(strPort), this.proxyConfig.getHostname(), this.proxyConfig.isOtlpResourceAttrsOnMetricsIncluded(), this.proxyConfig.isOtlpAppTagsOnMetricsIncluded());
                io.grpc.Server server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)traceHandler)).addService((BindableService)metricsHandler)).build();
                server.start();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "OTLP gRPC collector exception", e);
            }
            finally {
                this.activeListeners.dec();
            }
        }, "listener-otlp-grpc-" + strPort);
        logger.info("listening on port: " + strPort + " for OTLP data over gRPC");
    }

    protected void startOtlpHttpListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        OtlpHttpHandler channelHandler = new OtlpHttpHandler(handlerFactory, this.tokenAuthenticator, this.healthCheckManager, strPort, wfSender, this.preprocessors.get(strPort), sampler, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), this.proxyConfig.getHostname(), this.proxyConfig.getTraceDerivedCustomTagKeys(), this.proxyConfig.isOtlpResourceAttrsOnMetricsIncluded(), this.proxyConfig.isOtlpAppTagsOnMetricsIncluded());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-otlp-http-" + port);
        logger.info("listening on port: " + strPort + " for OTLP data over HTTP");
    }

    protected void startTraceZipkinListener(String strPort, ReportableEntityHandlerFactory handlerFactory, @Nullable WavefrontSender wfSender, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        ZipkinPortUnificationHandler channelHandler = new ZipkinPortUnificationHandler(strPort, this.healthCheckManager, handlerFactory, wfSender, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), this.preprocessors.get(strPort), sampler, this.proxyConfig.getTraceZipkinApplicationName(), this.proxyConfig.getTraceDerivedCustomTagKeys());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getTraceListenerMaxReceivedLength(), this.proxyConfig.getTraceListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-zipkin-trace-" + port);
        logger.info("listening on port: " + strPort + " for trace data (Zipkin format)");
    }

    @VisibleForTesting
    protected void startGraphiteListener(String strPort, ReportableEntityHandlerFactory handlerFactory, SharedGraphiteHostAnnotator hostAnnotator, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        WavefrontPortUnificationHandler wavefrontPortUnificationHandler = new WavefrontPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, this.decoderSupplier.get(), handlerFactory, hostAnnotator, this.preprocessors.get(strPort), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.HISTOGRAM).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), sampler, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.LOGS).isFeatureDisabled());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)wavefrontPortUnificationHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-graphite-" + port);
    }

    @VisibleForTesting
    protected void startDeltaCounterListener(String strPort, SharedGraphiteHostAnnotator hostAnnotator, final SenderTaskFactory senderTaskFactory, SpanSampler sampler) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        if (this.deltaCounterHandlerFactory == null) {
            this.deltaCounterHandlerFactory = new ReportableEntityHandlerFactory(){
                private final Map<String, ReportableEntityHandler<?, ?>> handlers = new ConcurrentHashMap();

                @Override
                public <T, U> ReportableEntityHandler<T, U> getHandler(HandlerKey handlerKey) {
                    return this.handlers.computeIfAbsent(handlerKey.getHandle(), k -> new DeltaCounterAccumulationHandlerImpl(handlerKey, PushAgent.this.proxyConfig.getPushBlockedSamples(), senderTaskFactory.createSenderTasks(handlerKey), PushAgent.this.validationConfiguration, PushAgent.this.proxyConfig.getDeltaCountersAggregationIntervalSeconds(), (tenantName, rate) -> ((EntityPropertiesFactory)PushAgent.this.entityPropertiesFactoryMap.get(tenantName)).get(ReportableEntityType.POINT).reportReceivedRate(handlerKey.getHandle(), (long)rate), PushAgent.this.blockedPointsLogger, ReportableEntityHandlerFactoryImpl.VALID_POINTS_LOGGER));
                }

                @Override
                public void shutdown(@Nonnull String handle) {
                    if (this.handlers.containsKey(handle)) {
                        this.handlers.values().forEach(ReportableEntityHandler::shutdown);
                    }
                }
            };
        }
        this.shutdownTasks.add(() -> this.deltaCounterHandlerFactory.shutdown(strPort));
        WavefrontPortUnificationHandler wavefrontPortUnificationHandler = new WavefrontPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, this.decoderSupplier.get(), this.deltaCounterHandlerFactory, hostAnnotator, this.preprocessors.get(strPort), () -> false, () -> false, () -> false, sampler, () -> false);
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)wavefrontPortUnificationHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-deltaCounter-" + port);
    }

    @VisibleForTesting
    protected void startRelayListener(String strPort, ReportableEntityHandlerFactory handlerFactory, SharedGraphiteHostAnnotator hostAnnotator) {
        int port = Integer.parseInt(strPort);
        this.registerPrefixFilter(strPort);
        this.registerTimestampFilter(strPort);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        ReportableEntityHandlerFactory handlerFactoryDelegate = this.proxyConfig.isPushRelayHistogramAggregator() ? new DelegatingReportableEntityHandlerFactoryImpl(handlerFactory){

            @Override
            public <T, U> ReportableEntityHandler<T, U> getHandler(HandlerKey handlerKey) {
                if (handlerKey.getEntityType() == ReportableEntityType.HISTOGRAM) {
                    ChronicleMap accumulator = ChronicleMap.of(HistogramKey.class, AgentDigest.class).keyMarshaller((BytesReader)HistogramUtils.HistogramKeyMarshaller.get()).valueMarshaller((SizedReader)AgentDigest.AgentDigestMarshaller.get()).entries(PushAgent.this.proxyConfig.getPushRelayHistogramAggregatorAccumulatorSize()).averageKeySize((double)PushAgent.this.proxyConfig.getHistogramDistAvgKeyBytes()).averageValueSize((double)PushAgent.this.proxyConfig.getHistogramDistAvgDigestBytes()).maxBloatFactor(1000.0).create();
                    AgentDigestFactory agentDigestFactory = new AgentDigestFactory(() -> (short)Math.min(PushAgent.this.proxyConfig.getPushRelayHistogramAggregatorCompression(), ((EntityPropertiesFactory)PushAgent.this.entityPropertiesFactoryMap.get("central")).getGlobalProperties().getHistogramStorageAccuracy()), TimeUnit.SECONDS.toMillis(PushAgent.this.proxyConfig.getPushRelayHistogramAggregatorFlushSecs()), PushAgent.this.proxyConfig.getTimeProvider());
                    AccumulationCache cachedAccumulator = new AccumulationCache((ConcurrentMap<HistogramKey, AgentDigest>)accumulator, agentDigestFactory, 0L, "histogram.accumulator.distributionRelay", null);
                    return new HistogramAccumulationHandlerImpl(handlerKey, cachedAccumulator, PushAgent.this.proxyConfig.getPushBlockedSamples(), null, PushAgent.this.validationConfiguration, true, (tenantName, rate) -> ((EntityPropertiesFactory)PushAgent.this.entityPropertiesFactoryMap.get(tenantName)).get(ReportableEntityType.HISTOGRAM).reportReceivedRate(handlerKey.getHandle(), (long)rate), PushAgent.this.blockedHistogramsLogger, ReportableEntityHandlerFactoryImpl.VALID_HISTOGRAMS_LOGGER);
                }
                return this.delegate.getHandler(handlerKey);
            }
        } : handlerFactory;
        Map<ReportableEntityType, ReportableEntityDecoder<?, ?>> filteredDecoders = this.decoderSupplier.get().entrySet().stream().filter(x -> !((ReportableEntityType)x.getKey()).equals((Object)ReportableEntityType.SOURCE_TAG)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        RelayPortUnificationHandler channelHandler = new RelayPortUnificationHandler(strPort, this.tokenAuthenticator, this.healthCheckManager, filteredDecoders, handlerFactoryDelegate, this.preprocessors.get(strPort), hostAnnotator, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.HISTOGRAM).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.LOGS).isFeatureDisabled(), this.apiContainer, this.proxyConfig);
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-relay-" + port);
    }

    protected void startLogsIngestionListener(int port, LogsIngester logsIngester) {
        if (this.tokenAuthenticator.authRequired()) {
            logger.warning("Filebeat log ingestion is not compatible with HTTP authentication, ignoring");
            return;
        }
        Server filebeatServer = new Server("0.0.0.0", port, this.proxyConfig.getListenerIdleConnectionTimeout(), Runtime.getRuntime().availableProcessors());
        filebeatServer.setMessageListener(new FilebeatIngester(logsIngester, System::currentTimeMillis));
        this.startAsManagedThread(port, () -> {
            try {
                this.activeListeners.inc();
                filebeatServer.listen();
            }
            catch (InterruptedException e) {
                logger.info("Filebeat server on port " + port + " shut down");
            }
            catch (Exception e) {
                if (e instanceof BindException) {
                    this.bindErrors.inc();
                    logger.severe("Unable to start listener - port " + port + " is already in use!");
                } else {
                    logger.log(Level.SEVERE, "Filebeat exception", e);
                }
            }
            finally {
                this.activeListeners.dec();
            }
        }, "listener-logs-filebeat-" + port);
        logger.info("listening on port: " + port + " for Filebeat logs");
    }

    @VisibleForTesting
    protected void startRawLogsIngestionListener(int port, LogsIngester logsIngester) {
        String strPort = String.valueOf(port);
        if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
            this.healthCheckManager.enableHealthcheck(port);
        }
        RawLogsIngesterPortUnificationHandler channelHandler = new RawLogsIngesterPortUnificationHandler(strPort, logsIngester, this.hostnameResolver, this.tokenAuthenticator, this.healthCheckManager, this.preprocessors.get(strPort));
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getRawLogsMaxReceivedLength(), this.proxyConfig.getRawLogsHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-logs-raw-" + port);
        logger.info("listening on port: " + strPort + " for raw logs");
    }

    @VisibleForTesting
    protected void startAdminListener(int port) {
        String strPort = String.valueOf(port);
        AdminPortUnificationHandler channelHandler = new AdminPortUnificationHandler(this.tokenAuthenticator, this.healthCheckManager, String.valueOf(port), this.proxyConfig.getAdminApiRemoteIpAllowRegex());
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-http-admin-" + port);
        logger.info("Admin port: " + port);
    }

    @VisibleForTesting
    protected void startHealthCheckListener(int port) {
        String strPort = String.valueOf(port);
        this.healthCheckManager.enableHealthcheck(port);
        HttpHealthCheckEndpointHandler channelHandler = new HttpHealthCheckEndpointHandler(this.healthCheckManager, port);
        this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)channelHandler, port, this.proxyConfig.getPushListenerMaxReceivedLength(), this.proxyConfig.getPushListenerHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext(strPort), this.getCorsConfig(strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-http-healthcheck-" + port);
        logger.info("Health check port enabled: " + port);
    }

    protected void startHistogramListeners(List<String> ports, ReportableEntityHandler<ReportPoint, String> pointHandler, SharedGraphiteHostAnnotator hostAnnotator, final @Nullable Granularity granularity, int flushSecs, boolean memoryCacheEnabled, File baseDirectory, Long accumulatorSize, int avgKeyBytes, int avgDigestBytes, short compression, boolean persist, SpanSampler sampler) throws Exception {
        if (ports.size() == 0) {
            return;
        }
        String listenerBinType = HistogramUtils.granularityToString(granularity);
        if (persist) {
            Preconditions.checkArgument((boolean)baseDirectory.isDirectory(), (Object)(baseDirectory.getAbsolutePath() + " must be a directory!"));
            Preconditions.checkArgument((boolean)baseDirectory.canWrite(), (Object)(baseDirectory.getAbsolutePath() + " must be write-able!"));
        }
        MapLoader<HistogramKey, AgentDigest, HistogramUtils.HistogramKeyMarshaller, AgentDigest.AgentDigestMarshaller> mapLoader = new MapLoader<HistogramKey, AgentDigest, HistogramUtils.HistogramKeyMarshaller, AgentDigest.AgentDigestMarshaller>(HistogramKey.class, AgentDigest.class, accumulatorSize, avgKeyBytes, avgDigestBytes, HistogramUtils.HistogramKeyMarshaller.get(), AgentDigest.AgentDigestMarshaller.get(), persist);
        File accumulationFile = new File(baseDirectory, "accumulator." + listenerBinType);
        ChronicleMap<HistogramKey, AgentDigest> accumulator = mapLoader.get(accumulationFile);
        this.histogramExecutor.scheduleWithFixedDelay(() -> {
            if ((long)accumulator.size() > accumulatorSize * 5L) {
                logger.severe("Histogram " + listenerBinType + " accumulator size (" + accumulator.size() + ") is more than 5x higher than currently configured size (" + accumulatorSize + "), which may cause severe performance degradation issues or data loss! If the data volume is expected to stay at this level, we strongly recommend increasing the value for accumulator size in wavefront.conf and restarting the proxy.");
            } else if ((long)accumulator.size() > accumulatorSize * 2L) {
                logger.warning("Histogram " + listenerBinType + " accumulator size (" + accumulator.size() + ") is more than 2x higher than currently configured size (" + accumulatorSize + "), which may cause performance issues. If the data volume is expected to stay at this level, we strongly recommend increasing the value for accumulator size in wavefront.conf and restarting the proxy.");
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        AgentDigestFactory agentDigestFactory = new AgentDigestFactory(() -> (short)Math.min(compression, ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).getGlobalProperties().getHistogramStorageAccuracy()), TimeUnit.SECONDS.toMillis(flushSecs), this.proxyConfig.getTimeProvider());
        final AccumulationCache cachedAccumulator = new AccumulationCache((ConcurrentMap<HistogramKey, AgentDigest>)accumulator, agentDigestFactory, memoryCacheEnabled ? accumulatorSize : 0L, "histogram.accumulator." + HistogramUtils.granularityToString(granularity), null);
        this.histogramExecutor.scheduleWithFixedDelay(cachedAccumulator::flush, this.proxyConfig.getHistogramAccumulatorResolveInterval(), this.proxyConfig.getHistogramAccumulatorResolveInterval(), TimeUnit.MILLISECONDS);
        this.histogramFlushRunnables.add(cachedAccumulator::flush);
        PointHandlerDispatcher dispatcher = new PointHandlerDispatcher(cachedAccumulator, pointHandler, this.proxyConfig.getTimeProvider(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.HISTOGRAM).isFeatureDisabled(), this.proxyConfig.getHistogramAccumulatorFlushMaxBatchSize() < 0 ? null : Integer.valueOf(this.proxyConfig.getHistogramAccumulatorFlushMaxBatchSize()), granularity);
        this.histogramExecutor.scheduleWithFixedDelay(dispatcher, this.proxyConfig.getHistogramAccumulatorFlushInterval(), this.proxyConfig.getHistogramAccumulatorFlushInterval(), TimeUnit.MILLISECONDS);
        this.histogramFlushRunnables.add(dispatcher);
        this.shutdownTasks.add(() -> {
            try {
                logger.fine("Flushing in-flight histogram accumulator digests: " + listenerBinType);
                cachedAccumulator.flush();
                logger.fine("Shutting down histogram accumulator cache: " + listenerBinType);
                accumulator.close();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Error flushing " + listenerBinType + " accumulator, possibly unclean shutdown: ", t);
            }
        });
        ReportableEntityHandlerFactory histogramHandlerFactory = new ReportableEntityHandlerFactory(){
            private final Map<HandlerKey, ReportableEntityHandler<?, ?>> handlers = new ConcurrentHashMap();

            @Override
            public <T, U> ReportableEntityHandler<T, U> getHandler(HandlerKey handlerKey) {
                return this.handlers.computeIfAbsent(handlerKey, k -> new HistogramAccumulationHandlerImpl(handlerKey, cachedAccumulator, PushAgent.this.proxyConfig.getPushBlockedSamples(), granularity, PushAgent.this.validationConfiguration, granularity == null, null, PushAgent.this.blockedHistogramsLogger, ReportableEntityHandlerFactoryImpl.VALID_HISTOGRAMS_LOGGER));
            }

            @Override
            public void shutdown(@Nonnull String handle) {
                this.handlers.values().forEach(ReportableEntityHandler::shutdown);
            }
        };
        ports.forEach(strPort -> {
            int port = Integer.parseInt(strPort);
            this.registerPrefixFilter((String)strPort);
            this.registerTimestampFilter((String)strPort);
            if (this.proxyConfig.isHttpHealthCheckAllPorts()) {
                this.healthCheckManager.enableHealthcheck(port);
            }
            WavefrontPortUnificationHandler wavefrontPortUnificationHandler = new WavefrontPortUnificationHandler((String)strPort, this.tokenAuthenticator, this.healthCheckManager, this.decoderSupplier.get(), histogramHandlerFactory, hostAnnotator, this.preprocessors.get((String)strPort), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.HISTOGRAM).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE).isFeatureDisabled(), () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.TRACE_SPAN_LOGS).isFeatureDisabled(), sampler, () -> ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get("central")).get(ReportableEntityType.LOGS).isFeatureDisabled());
            this.startAsManagedThread(port, (Runnable)new TcpIngester(ProxyUtil.createInitializer((ChannelHandler)wavefrontPortUnificationHandler, port, this.proxyConfig.getHistogramMaxReceivedLength(), this.proxyConfig.getHistogramHttpBufferSize(), this.proxyConfig.getListenerIdleConnectionTimeout(), this.getSslContext((String)strPort), this.getCorsConfig((String)strPort)), port).withChildChannelOptions(this.childChannelOptions), "listener-histogram-" + port);
            logger.info("listening on port: " + port + " for histogram samples, accumulating to the " + listenerBinType);
        });
    }

    private void registerTimestampFilter(String strPort) {
        this.preprocessors.getSystemPreprocessor(strPort).forReportPoint().addFilter(0, new ReportPointTimestampInRangeFilter(this.proxyConfig.getDataBackfillCutoffHours(), this.proxyConfig.getDataPrefillCutoffHours()));
    }

    private void registerPrefixFilter(String strPort) {
        if (this.proxyConfig.getPrefix() != null && !this.proxyConfig.getPrefix().isEmpty()) {
            this.preprocessors.getSystemPreprocessor(strPort).forReportPoint().addTransformer((Function<ReportPoint, ReportPoint>)((Object)new ReportPointAddPrefixTransformer(this.proxyConfig.getPrefix())));
        }
    }

    @Override
    protected void processConfiguration(String tenantName, AgentConfiguration config) {
        try {
            Long pointsPerBatch = config.getPointsPerBatch();
            EntityPropertiesFactory tenantSpecificEntityProps = (EntityPropertiesFactory)this.entityPropertiesFactoryMap.get(tenantName);
            if (BooleanUtils.isTrue((Boolean)config.getCollectorSetsPointsPerBatch())) {
                if (pointsPerBatch != null) {
                    tenantSpecificEntityProps.get(ReportableEntityType.POINT).setDataPerBatch(pointsPerBatch.intValue());
                    logger.fine("Proxy push batch set to (remotely) " + pointsPerBatch);
                }
            } else {
                tenantSpecificEntityProps.get(ReportableEntityType.POINT).setDataPerBatch(null);
                logger.fine("Proxy push batch set to (locally) " + tenantSpecificEntityProps.get(ReportableEntityType.POINT).getDataPerBatch());
            }
            if (config.getHistogramStorageAccuracy() != null) {
                tenantSpecificEntityProps.getGlobalProperties().setHistogramStorageAccuracy(config.getHistogramStorageAccuracy().shortValue());
            }
            if (!this.proxyConfig.isBackendSpanHeadSamplingPercentIgnored()) {
                double previousSamplingRate = tenantSpecificEntityProps.getGlobalProperties().getTraceSamplingRate();
                tenantSpecificEntityProps.getGlobalProperties().setTraceSamplingRate(config.getSpanSamplingRate());
                this.rateSampler.setSamplingRate(tenantSpecificEntityProps.getGlobalProperties().getTraceSamplingRate());
                if (previousSamplingRate != tenantSpecificEntityProps.getGlobalProperties().getTraceSamplingRate()) {
                    logger.info("Proxy trace span sampling rate set to " + tenantSpecificEntityProps.getGlobalProperties().getTraceSamplingRate());
                }
            }
            tenantSpecificEntityProps.getGlobalProperties().setDropSpansDelayedMinutes(config.getDropSpansDelayedMinutes());
            tenantSpecificEntityProps.getGlobalProperties().setActiveSpanSamplingPolicies(config.getActiveSpanSamplingPolicies());
            this.updateRateLimiter(tenantName, ReportableEntityType.POINT, config.getCollectorSetsRateLimit(), config.getCollectorRateLimit(), config.getGlobalCollectorRateLimit());
            this.updateRateLimiter(tenantName, ReportableEntityType.HISTOGRAM, config.getCollectorSetsRateLimit(), config.getHistogramRateLimit(), config.getGlobalHistogramRateLimit());
            this.updateRateLimiter(tenantName, ReportableEntityType.SOURCE_TAG, config.getCollectorSetsRateLimit(), config.getSourceTagsRateLimit(), config.getGlobalSourceTagRateLimit());
            this.updateRateLimiter(tenantName, ReportableEntityType.TRACE, config.getCollectorSetsRateLimit(), config.getSpanRateLimit(), config.getGlobalSpanRateLimit());
            this.updateRateLimiter(tenantName, ReportableEntityType.TRACE_SPAN_LOGS, config.getCollectorSetsRateLimit(), config.getSpanLogsRateLimit(), config.getGlobalSpanLogsRateLimit());
            this.updateRateLimiter(tenantName, ReportableEntityType.EVENT, config.getCollectorSetsRateLimit(), config.getEventsRateLimit(), config.getGlobalEventRateLimit());
            this.updateRateLimiter(tenantName, ReportableEntityType.LOGS, config.getCollectorSetsRateLimit(), config.getLogsRateLimit(), config.getGlobalLogsRateLimit());
            if (BooleanUtils.isTrue((Boolean)config.getCollectorSetsRetryBackoff())) {
                if (config.getRetryBackoffBaseSeconds() != null) {
                    tenantSpecificEntityProps.getGlobalProperties().setRetryBackoffBaseSeconds(config.getRetryBackoffBaseSeconds());
                    logger.fine("Proxy backoff base set to (remotely) " + config.getRetryBackoffBaseSeconds());
                }
            } else {
                tenantSpecificEntityProps.getGlobalProperties().setRetryBackoffBaseSeconds(null);
                logger.fine("Proxy backoff base set to (locally) " + tenantSpecificEntityProps.getGlobalProperties().getRetryBackoffBaseSeconds());
            }
            tenantSpecificEntityProps.get(ReportableEntityType.HISTOGRAM).setFeatureDisabled(BooleanUtils.isTrue((Boolean)config.getHistogramDisabled()));
            tenantSpecificEntityProps.get(ReportableEntityType.TRACE).setFeatureDisabled(BooleanUtils.isTrue((Boolean)config.getTraceDisabled()));
            tenantSpecificEntityProps.get(ReportableEntityType.TRACE_SPAN_LOGS).setFeatureDisabled(BooleanUtils.isTrue((Boolean)config.getSpanLogsDisabled()));
            tenantSpecificEntityProps.get(ReportableEntityType.LOGS).setFeatureDisabled(BooleanUtils.isTrue((Boolean)config.getLogsDisabled()));
            this.preprocessors.processRemoteRules((String)ObjectUtils.firstNonNull((Object[])new String[]{config.getPreprocessorRules(), ""}));
            this.validationConfiguration.updateFrom(config.getValidationConfiguration());
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Error during configuration update", e);
        }
        try {
            super.processConfiguration(tenantName, config);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void updateRateLimiter(String tenantName, ReportableEntityType entityType, @Nullable Boolean collectorSetsRateLimit, @Nullable Number collectorRateLimit, @Nullable Number globalRateLimit) {
        EntityProperties entityProperties = ((EntityPropertiesFactory)this.entityPropertiesFactoryMap.get(tenantName)).get(entityType);
        RecyclableRateLimiter rateLimiter = entityProperties.getRateLimiter();
        if (rateLimiter != null) {
            if (BooleanUtils.isTrue((Boolean)collectorSetsRateLimit)) {
                if (collectorRateLimit != null && rateLimiter.getRate() != collectorRateLimit.doubleValue()) {
                    rateLimiter.setRate(collectorRateLimit.doubleValue());
                    entityProperties.setDataPerBatch(Math.min(collectorRateLimit.intValue(), entityProperties.getDataPerBatch()));
                    logger.warning("[" + tenantName + "]: " + entityType.toCapitalizedString() + " rate limit set to " + collectorRateLimit + entityType.getRateUnit() + " remotely");
                }
            } else {
                double rateLimit = Math.min(entityProperties.getRateLimit(), (double)((Number)ObjectUtils.firstNonNull((Object[])new Number[]{globalRateLimit, 10000000})).intValue());
                if (rateLimiter.getRate() != rateLimit) {
                    rateLimiter.setRate(rateLimit);
                    if ((double)entityProperties.getDataPerBatchOriginal() > rateLimit) {
                        entityProperties.setDataPerBatch((int)rateLimit);
                    } else {
                        entityProperties.setDataPerBatch(null);
                    }
                    if (rateLimit >= 1.0E7) {
                        logger.warning(entityType.toCapitalizedString() + " rate limit is no longer enforced by remote");
                    } else if (this.proxyCheckinScheduler != null && this.proxyCheckinScheduler.getSuccessfulCheckinCount() > 1L) {
                        logger.warning(entityType.toCapitalizedString() + " rate limit restored to " + rateLimit + entityType.getRateUnit());
                    }
                }
            }
        }
    }

    protected TokenAuthenticator configureTokenAuthenticator() {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setUserAgent(this.proxyConfig.getHttpUserAgent()).setMaxConnPerRoute(10).setMaxConnTotal(10).setConnectionTimeToLive(1L, TimeUnit.MINUTES).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.proxyConfig.getHttpAutoRetries(), true)).setDefaultRequestConfig(RequestConfig.custom().setContentCompressionEnabled(true).setRedirectsEnabled(true).setConnectTimeout(this.proxyConfig.getHttpConnectTimeout()).setConnectionRequestTimeout(this.proxyConfig.getHttpConnectTimeout()).setSocketTimeout(this.proxyConfig.getHttpRequestTimeout()).build()).build();
        return TokenAuthenticatorBuilder.create().setTokenValidationMethod(this.proxyConfig.getAuthMethod()).setHttpClient((HttpClient)httpClient).setTokenIntrospectionServiceUrl(this.proxyConfig.getAuthTokenIntrospectionServiceUrl()).setTokenIntrospectionAuthorizationHeader(this.proxyConfig.getAuthTokenIntrospectionAuthorizationHeader()).setAuthResponseRefreshInterval(this.proxyConfig.getAuthResponseRefreshInterval()).setAuthResponseMaxTtl(this.proxyConfig.getAuthResponseMaxTtl()).setStaticToken(this.proxyConfig.getAuthStaticToken()).build();
    }

    protected void startAsManagedThread(int port, Runnable target, @Nullable String threadName) {
        Thread thread = new Thread(target);
        if (threadName != null) {
            thread.setName(threadName);
        }
        this.listeners.put(port, thread);
        thread.start();
    }

    @Override
    public void stopListeners() {
        this.listeners.values().forEach(Thread::interrupt);
        this.listeners.values().forEach(thread -> {
            try {
                thread.join(TimeUnit.SECONDS.toMillis(10L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Override
    protected void stopListener(int port) {
        Thread listener = this.listeners.remove(port);
        if (listener == null) {
            return;
        }
        listener.interrupt();
        try {
            listener.join(TimeUnit.SECONDS.toMillis(10L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.handlerFactory.shutdown(String.valueOf(port));
        this.senderTaskFactory.shutdown(String.valueOf(port));
    }

    @Override
    protected void truncateBacklog() {
        this.senderTaskFactory.truncateBuffers();
    }

    private static /* synthetic */ ChannelHandler lambda$startPickleListener$27(ChannelHandler channelHandler) {
        return channelHandler;
    }

    private /* synthetic */ void lambda$startListeners$13(HttpClient httpClient, String strPort) {
        this.startDataDogListener(strPort, this.handlerFactory, httpClient);
    }
}

