/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.wavefront.agent.ProxyConfig;
import com.wavefront.agent.channel.ConnectionTrackingHandler;
import com.wavefront.agent.channel.IdleStateEventHandler;
import com.wavefront.agent.channel.PlainTextOrHttpFrameDecoder;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;

abstract class ProxyUtil {
    protected static final Logger logger = Logger.getLogger("proxy");

    private ProxyUtil() {
    }

    static UUID getOrCreateProxyId(ProxyConfig proxyConfig) {
        if (proxyConfig.isEphemeral()) {
            UUID proxyId = UUID.randomUUID();
            logger.info("Ephemeral proxy id created: " + proxyId);
            return proxyId;
        }
        return ProxyUtil.getOrCreateProxyIdFromFile(proxyConfig.getIdFile());
    }

    static UUID getOrCreateProxyIdFromFile(@Nullable String idFileName) {
        File proxyIdFile;
        UUID proxyId = UUID.randomUUID();
        if (idFileName != null) {
            proxyIdFile = new File(idFileName);
        } else {
            File userHome = new File(System.getProperty("user.home"));
            if (!userHome.exists() || !userHome.isDirectory()) {
                throw new RuntimeException("Cannot read from user.home, quitting");
            }
            File configDirectory = new File(userHome, ".dshell");
            if (configDirectory.exists()) {
                if (!configDirectory.isDirectory()) {
                    throw new RuntimeException(configDirectory + " must be a directory!");
                }
            } else if (!configDirectory.mkdir()) {
                throw new RuntimeException("Cannot create .dshell directory under " + userHome);
            }
            proxyIdFile = new File(configDirectory, "id");
        }
        if (proxyIdFile.exists()) {
            if (proxyIdFile.isFile()) {
                try {
                    proxyId = UUID.fromString(Objects.requireNonNull(Files.asCharSource((File)proxyIdFile, (Charset)Charsets.UTF_8).readFirstLine()));
                    logger.info("Proxy Id read from file: " + proxyId);
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException("Cannot read proxy id from " + proxyIdFile + ", content is malformed");
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot read from " + proxyIdFile, e);
                }
            }
            throw new RuntimeException(proxyIdFile + " is not a file!");
        }
        logger.info("Proxy Id created: " + proxyId);
        try {
            Files.asCharSink((File)proxyIdFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)proxyId.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to " + proxyIdFile);
        }
        return proxyId;
    }

    static ChannelInitializer<SocketChannel> createInitializer(ChannelHandler channelHandler, int port, int messageMaxLength, int httpRequestBufferSize, int idleTimeout, @Nullable SslContext sslContext, @Nullable CorsConfig corsConfig) {
        return ProxyUtil.createInitializer((Iterable<Supplier<ChannelHandler>>)ImmutableList.of(() -> new PlainTextOrHttpFrameDecoder(channelHandler, corsConfig, messageMaxLength, httpRequestBufferSize)), port, idleTimeout, sslContext);
    }

    static ChannelInitializer<SocketChannel> createInitializer(Iterable<Supplier<ChannelHandler>> channelHandlerSuppliers, int port, final int idleTimeout, final @Nullable SslContext sslContext) {
        String strPort = String.valueOf(port);
        IdleStateEventHandler idleStateEventHandler = new IdleStateEventHandler(Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "connections.idle.closed", new String[]{"port", strPort})));
        ConnectionTrackingHandler connectionTracker = new ConnectionTrackingHandler(Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "connections.accepted", new String[]{"port", strPort})), Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "connections.active", new String[]{"port", strPort})));
        if (sslContext != null) {
            logger.info("TLS enabled on port: " + port);
        }
        return new ChannelInitializer<SocketChannel>((ChannelHandler)idleStateEventHandler, (ChannelHandler)connectionTracker, channelHandlerSuppliers){
            final /* synthetic */ ChannelHandler val$idleStateEventHandler;
            final /* synthetic */ ChannelHandler val$connectionTracker;
            final /* synthetic */ Iterable val$channelHandlerSuppliers;
            {
                this.val$idleStateEventHandler = channelHandler;
                this.val$connectionTracker = channelHandler2;
                this.val$channelHandlerSuppliers = iterable;
            }

            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslContext != null) {
                    pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                pipeline.addFirst("idlehandler", (ChannelHandler)new IdleStateHandler(idleTimeout, 0, 0));
                pipeline.addLast("idlestateeventhandler", this.val$idleStateEventHandler);
                pipeline.addLast("connectiontracker", this.val$connectionTracker);
                this.val$channelHandlerSuppliers.forEach(x -> pipeline.addLast(new ChannelHandler[]{(ChannelHandler)x.get()}));
            }
        };
    }
}

