/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.agent;

import com.google.common.base.Preconditions;
import com.wavefront.common.TaggedMetricName;
import com.wavefront.common.Utils;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.management.NotificationEmitter;

public class ProxyMemoryGuard {
    private static final Logger logger = Logger.getLogger(ProxyMemoryGuard.class.getCanonicalName());
    private final Supplier<Counter> drainBuffersCount = Utils.lazySupplier(() -> Metrics.newCounter((MetricName)new TaggedMetricName("buffer", "flush-count", new String[]{"reason", "heapUsageThreshold"})));

    public ProxyMemoryGuard(@Nonnull Runnable flushTask, double threshold) {
        Preconditions.checkArgument((threshold > 0.0 ? 1 : 0) != 0, (Object)"ProxyMemoryGuard threshold must be > 0!");
        Preconditions.checkArgument((threshold <= 1.0 ? 1 : 0) != 0, (Object)"ProxyMemoryGuard threshold must be <= 1!");
        MemoryPoolMXBean tenuredGenPool = this.getTenuredGenPool();
        if (tenuredGenPool == null) {
            return;
        }
        tenuredGenPool.setUsageThreshold((long)((double)tenuredGenPool.getUsage().getMax() * threshold));
        NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        emitter.addNotificationListener((notification, obj) -> {
            if (notification.getType().equals("java.management.memory.threshold.exceeded")) {
                logger.warning("Heap usage threshold exceeded - draining buffers to disk!");
                this.drainBuffersCount.get().inc();
                flushTask.run();
                logger.info("Draining buffers to disk: finished");
            }
        }, null, null);
    }

    private MemoryPoolMXBean getTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        return null;
    }
}

