/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanIngesterFormatter
extends AbstractIngesterFormatter<Span> {
    private SpanIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<Span> newBuilder() {
        return new SpanIngesterFormatBuilder();
    }

    @Override
    public Span drive(String input, String defaultHostName, String customerId, @Nullable List<String> customSourceTags) {
        Queue<Token> queue = this.getQueue(input);
        Span span = new Span();
        span.setCustomer(customerId);
        if (defaultHostName != null) {
            span.setSource(defaultHostName);
        }
        AbstractIngesterFormatter.SpanWrapper wrapper = new AbstractIngesterFormatter.SpanWrapper(span);
        try {
            for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
                element.consume(queue, wrapper);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (!queue.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        List<Annotation> annotations = span.getAnnotations();
        if (annotations != null) {
            boolean hasTrueSource = false;
            Iterator<Annotation> iterator = annotations.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = iterator.next();
                if (customSourceTags != null && !hasTrueSource && customSourceTags.contains(annotation.getKey())) {
                    span.setSource(annotation.getValue());
                }
                switch (annotation.getKey()) {
                    case "source": 
                    case "host": {
                        span.setSource(annotation.getValue());
                        iterator.remove();
                        hasTrueSource = true;
                        break;
                    }
                    case "spanId": {
                        span.setSpanId(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                    case "traceId": {
                        span.setTraceId(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                }
            }
        }
        if (span.getSource() == null) {
            throw new RuntimeException("source can't be null: " + input);
        }
        if (span.getSpanId() == null) {
            throw new RuntimeException("spanId can't be null: " + input);
        }
        if (span.getTraceId() == null) {
            throw new RuntimeException("traceId can't be null: " + input);
        }
        return Span.newBuilder(span).build();
    }

    public static class SpanIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<Span> {
        public SpanIngesterFormatter build() {
            return new SpanIngesterFormatter(this.elements);
        }
    }
}

