/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.predicates;

import com.google.common.collect.ImmutableList;
import com.wavefront.common.PatternMatchPredicate;
import com.wavefront.predicates.CachingRegexMatcher;
import com.wavefront.predicates.PredicateEvalExpression;
import com.wavefront.predicates.PredicateMatchOp;
import com.wavefront.predicates.StringExpression;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.ReportHistogram;
import wavefront.report.ReportMetric;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public class MultiStringComparisonExpression
implements PredicateEvalExpression {
    private final String scope;
    private final StringExpression arg;
    private final PredicateMatchOp matchOp;
    private final BiFunction<String, String, Boolean> cmp;

    private MultiStringComparisonExpression(String scope, StringExpression arg, PredicateMatchOp matchOp, BiFunction<String, String, Boolean> cmp) {
        this.scope = scope;
        this.arg = arg;
        this.matchOp = matchOp;
        this.cmp = cmp;
    }

    @Override
    public double getValue(Object entity) {
        Object annotations;
        if (entity == null) {
            return 0.0;
        }
        if (entity instanceof Span) {
            annotations = this.scope.equals("spanName") ? ImmutableList.of((Object)((Span)((Object)entity)).getName()) : (this.scope.equals("sourceName") ? ImmutableList.of((Object)((Span)((Object)entity)).getSource()) : ((Span)((Object)entity)).getAnnotations().stream().filter(a -> a.getKey().equals(this.scope)).map(Annotation::getValue).collect(Collectors.toList()));
        } else if (entity instanceof ReportMetric) {
            annotations = this.scope.equals("metricName") ? ImmutableList.of((Object)((ReportMetric)((Object)entity)).getMetric()) : (this.scope.equals("sourceName") ? ImmutableList.of((Object)((ReportMetric)((Object)entity)).getHost()) : ((ReportMetric)((Object)entity)).getAnnotations().stream().filter(a -> a.getKey().equals(this.scope)).map(Annotation::getValue).collect(Collectors.toList()));
        } else if (entity instanceof ReportHistogram) {
            annotations = this.scope.equals("metricName") ? ImmutableList.of((Object)((ReportHistogram)((Object)entity)).getMetric()) : (this.scope.equals("sourceName") ? ImmutableList.of((Object)((ReportHistogram)((Object)entity)).getHost()) : ((ReportHistogram)((Object)entity)).getAnnotations().stream().filter(a -> a.getKey().equals(this.scope)).map(Annotation::getValue).collect(Collectors.toList()));
        } else if (entity instanceof ReportPoint) {
            annotations = this.scope.equals("metricName") ? ImmutableList.of((Object)((ReportPoint)((Object)entity)).getMetric()) : (this.scope.equals("sourceName") ? ImmutableList.of((Object)((ReportPoint)((Object)entity)).getHost()) : ImmutableList.of((Object)((ReportPoint)((Object)entity)).getAnnotations().getOrDefault(this.scope, "")));
        } else {
            throw new IllegalArgumentException(entity.getClass().getCanonicalName() + " is not supported!");
        }
        switch (this.matchOp) {
            case ALL: {
                return PredicateEvalExpression.asDouble(annotations.stream().allMatch(x -> this.cmp.apply((String)x, this.arg.getString(entity))));
            }
            case ANY: {
                return PredicateEvalExpression.asDouble(annotations.stream().anyMatch(x -> this.cmp.apply((String)x, this.arg.getString(entity))));
            }
            case NONE: {
                return PredicateEvalExpression.asDouble(annotations.stream().noneMatch(x -> this.cmp.apply((String)x, this.arg.getString(entity))));
            }
        }
        throw new IllegalArgumentException("Unknown matchOp type: " + (Object)((Object)this.matchOp));
    }

    public static PredicateEvalExpression of(String scope, StringExpression argument, PredicateMatchOp matchOp, String op) {
        switch (op) {
            case "=": 
            case "equals": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, String::equals);
            }
            case "startsWith": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, String::startsWith);
            }
            case "endsWith": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, String::endsWith);
            }
            case "contains": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, String::contains);
            }
            case "matches": {
                Predicate<String> match = PatternMatchPredicate.buildPredicate(argument.getString(null), false);
                return new MultiStringComparisonExpression(scope, argument, matchOp, (s1, s2) -> match.test((String)s1));
            }
            case "regexMatch": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, new CachingRegexMatcher());
            }
            case "equalsIgnoreCase": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, String::equalsIgnoreCase);
            }
            case "startsWithIgnoreCase": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, StringUtils::startsWithIgnoreCase);
            }
            case "endsWithIgnoreCase": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, StringUtils::endsWithIgnoreCase);
            }
            case "containsIgnoreCase": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, StringUtils::containsIgnoreCase);
            }
            case "matchesIgnoreCase": {
                Predicate<String> matchCI = PatternMatchPredicate.buildPredicate(argument.getString(null), true);
                return new MultiStringComparisonExpression(scope, argument, matchOp, (s1, s2) -> matchCI.test((String)s1));
            }
            case "regexMatchIgnoreCase": {
                return new MultiStringComparisonExpression(scope, argument, matchOp, new CachingRegexMatcher(2));
            }
        }
        throw new IllegalArgumentException(op + " is not handled");
    }
}

