/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.wavefront.common.MetricMangler;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.PickleProtocolDecoder;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.razorvine.pickle.Unpickler;
import wavefront.report.ReportMetric;

public class PickleProtocolMetricDecoder
implements ReportableEntityDecoder<byte[], ReportMetric> {
    protected static final Logger logger = Logger.getLogger(PickleProtocolDecoder.class.getCanonicalName());
    private final int port;
    private final String defaultHostName;
    private final List<String> customSourceTags;
    private final MetricMangler metricMangler;
    private final ThreadLocal<Unpickler> unpicklerThreadLocal = ThreadLocal.withInitial(Unpickler::new);

    public PickleProtocolMetricDecoder(String hostName, List<String> customSourceTags, MetricMangler mangler, int port) {
        Preconditions.checkNotNull((Object)hostName);
        this.defaultHostName = hostName;
        Preconditions.checkNotNull(customSourceTags);
        this.customSourceTags = customSourceTags;
        this.metricMangler = mangler;
        this.port = port;
    }

    @Override
    public void decode(byte[] msg, List<ReportMetric> out, String customerId, IngesterContext ctx) {
        Object dataRaw;
        ByteArrayInputStream is = new ByteArrayInputStream(msg);
        try {
            dataRaw = this.unpicklerThreadLocal.get().load((InputStream)is);
            if (!(dataRaw instanceof List)) {
                throw new IllegalArgumentException(String.format("[%d] unable to unpickle data (unpickle did not return list)", this.port));
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(String.format("[%d] unable to unpickle data", this.port), ioe);
        }
        List data = (List)dataRaw;
        for (Object[] o : data) {
            double value;
            long ts;
            Object[] details = (Object[])o[1];
            if (details == null || details.length != 2) {
                logger.warning(String.format("[%d] Unexpected pickle protocol input", this.port));
                continue;
            }
            if (details[0] == null) {
                logger.warning(String.format("[%d] Unexpected pickle protocol input (timestamp is null)", this.port));
                continue;
            }
            if (details[0] instanceof Double) {
                ts = ((Double)details[0]).longValue() * 1000L;
            } else if (details[0] instanceof Long) {
                ts = (Long)details[0] * 1000L;
            } else if (details[0] instanceof Integer) {
                ts = ((Integer)details[0]).longValue() * 1000L;
            } else {
                logger.warning(String.format("[%d] Unexpected pickle protocol input (details[0]: %s)", this.port, details[0].getClass().getName()));
                continue;
            }
            if (details[1] == null) continue;
            if (details[1] instanceof Double) {
                value = (Double)details[1];
            } else if (details[1] instanceof Long) {
                value = ((Long)details[1]).longValue();
            } else if (details[1] instanceof Integer) {
                value = ((Integer)details[1]).intValue();
            } else {
                logger.warning(String.format("[%d] Unexpected pickle protocol input (value is null)", this.port));
                continue;
            }
            ReportMetric point = new ReportMetric();
            MetricMangler.MetricComponents components = this.metricMangler.extractComponents(o[0].toString());
            point.setMetric(components.metric);
            String host = components.source;
            if (host == null) {
                host = AbstractIngesterFormatter.getHost(point.getAnnotations(), this.customSourceTags);
            }
            if (host == null) {
                host = this.defaultHostName;
            }
            point.setHost(host);
            point.setCustomer(customerId);
            point.setTimestamp(ts);
            point.setValue(value);
            point.setAnnotations(Collections.emptyList());
            out.add(point);
        }
    }
}

