/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportMetricIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import wavefront.report.ReportMetric;

public class OpenTSDBMetricDecoder
implements ReportableEntityDecoder<String, ReportMetric> {
    private static final AbstractIngesterFormatter<ReportMetric> FORMAT = ReportMetricIngesterFormatter.newBuilder().caseInsensitiveLiterals((List<String>)ImmutableList.of((Object)"put")).text(ReportMetric::setMetric).timestamp(ReportMetric::setTimestamp).value(ReportMetric::setValue).annotationList(ReportMetric::setAnnotations).build();
    private final String hostName;
    private final List<String> customSourceTags;

    public OpenTSDBMetricDecoder(List<String> customSourceTags) {
        this("unknown", customSourceTags);
    }

    public OpenTSDBMetricDecoder(String hostName, List<String> customSourceTags) {
        Preconditions.checkNotNull((Object)hostName);
        Preconditions.checkNotNull(customSourceTags);
        this.hostName = hostName;
        this.customSourceTags = customSourceTags;
    }

    @Override
    public void decode(String msg, List<ReportMetric> out, String customerId, IngesterContext ctx) {
        ReportMetric point = FORMAT.drive(msg, () -> this.hostName, customerId, this.customSourceTags, ctx);
        if (out != null) {
            out.add(point);
        }
    }
}

