/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.wavefront.data.ParseException;
import com.wavefront.ingester.ReportMetricDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.ReportMetric;

public class GraphiteReportMetricDecoder
extends ReportMetricDecoder {
    private static final Pattern CUSTOMERID = Pattern.compile("[a-z]+");

    public GraphiteReportMetricDecoder(@Nullable Supplier<String> hostNameSupplier, List<String> customSourceTags) {
        super(hostNameSupplier, customSourceTags);
    }

    @Override
    public void decode(String msg, List<ReportMetric> out) {
        ArrayList output = Lists.newArrayList();
        this.decode(msg, output, "dummy");
        if (!output.isEmpty()) {
            for (ReportMetric rp : output) {
                String metricName = rp.getMetric();
                ArrayList metricParts = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)metricName));
                if (metricParts.size() <= 1) {
                    throw new ParseException("Metric name does not contain a customer id: " + metricName);
                }
                String customerId = (String)metricParts.get(0);
                if (CUSTOMERID.matcher(customerId).matches()) {
                    metricName = Joiner.on((String)".").join(metricParts.subList(1, metricParts.size()));
                }
                out.add(ReportMetric.newBuilder(rp).setMetric(metricName).setCustomer(customerId).build());
            }
        }
    }
}

