/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.StringParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportEvent;

public class EventIngesterFormatter
extends AbstractIngesterFormatter<ReportEvent> {
    private EventIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportEvent>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportEvent> newBuilder() {
        return new EventIngesterFormatBuilder();
    }

    @Override
    public ReportEvent drive(String input, Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags, @Nullable IngesterContext ingesterContext) {
        ReportEvent event = new ReportEvent();
        StringParser parser = new StringParser(input);
        event.setHosts(new ArrayList<String>());
        event.setAnnotations(new ArrayList<Annotation>());
        event.setCustomer(customerId);
        for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
            element.consume(parser, event);
        }
        List<Annotation> annotations = event.getAnnotations();
        String defaultGroup = "Default";
        String defaultDetails = null;
        if (annotations != null) {
            Iterator<Annotation> iterator = annotations.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = iterator.next();
                switch (annotation.getKey()) {
                    case "eventId": {
                        event.setEventId(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                    case "host": {
                        event.getHosts().add(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                    case "group": {
                        event.setGroup(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                    case "details": {
                        event.setDetails(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                    case "description": {
                        defaultDetails = annotation.getValue();
                        iterator.remove();
                        break;
                    }
                    case "type": {
                        defaultGroup = annotation.getValue();
                    }
                }
            }
        }
        if (event.getDetails() == null) {
            event.setDetails(defaultDetails);
        } else if (defaultDetails != null) {
            event.getAnnotations().add(new Annotation("description", defaultDetails));
        }
        if (event.getEndMillis() == 0L || event.getEndMillis() <= event.getStartMillis()) {
            event.setEndMillis(event.getStartMillis() + 1L);
        }
        if (event.getHosts() == null && defaultHostNameSupplier != null) {
            event.setHosts((List<String>)ImmutableList.of((Object)defaultHostNameSupplier.get()));
        }
        if (event.getHosts() == null) {
            throw new IllegalArgumentException("hosts can't be null: " + input);
        }
        if (event.getGroup() == null) {
            event.setGroup(defaultGroup);
        }
        if (event.getEventId() == null) {
            event.setEventId(UUID.randomUUID().toString());
        }
        return event;
    }

    public static class EventIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportEvent> {
        public EventIngesterFormatter build() {
            return new EventIngesterFormatter(this.elements);
        }
    }
}

