/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavefront.common.SerializerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import wavefront.report.Annotation;
import wavefront.report.ReportEvent;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Event
implements Serializable {
    @JsonProperty
    private String group;
    @JsonProperty
    private String eventId;
    @JsonProperty
    private long startMillis;
    @JsonProperty
    private Long endMillis;
    @JsonProperty
    private String customer;
    @JsonProperty
    private List<String> hosts;
    @JsonProperty
    private List<Annotation> annotations;
    @JsonProperty
    private String details;

    private Event() {
    }

    public Event(ReportEvent event) {
        this.group = event.getGroup();
        this.eventId = event.getEventId();
        this.startMillis = event.getStartMillis();
        this.endMillis = event.getEndMillis();
        this.annotations = event.getAnnotations();
        this.customer = event.getCustomer();
        this.hosts = new ArrayList<String>(event.getHosts());
        this.details = event.getDetails();
    }

    public String getGroup() {
        return this.group;
    }

    public String getEventId() {
        return this.eventId;
    }

    public long getStartMillis() {
        return this.startMillis;
    }

    @JsonProperty
    public Long getEndMillis() {
        return this.endMillis;
    }

    @JsonProperty
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty
    public String getCustomer() {
        return this.customer;
    }

    @JsonProperty
    public List<String> getHosts() {
        return this.hosts;
    }

    @JsonProperty
    public String getDetails() {
        return this.details;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.group == null ? 0 : this.group.hashCode());
        result = result * 31 + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = result * 31 + (int)(this.startMillis ^ this.startMillis >>> 32);
        result = result * 31 + (this.endMillis == null ? 0 : (int)(this.endMillis ^ this.endMillis >>> 32));
        result = result * 31 + this.annotations.hashCode();
        result = result * 31 + this.customer.hashCode();
        result = result * 31 + this.hosts.hashCode();
        result = result * 31 + (this.details == null ? 0 : this.details.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (!Objects.equals(this.group, other.group)) {
            return false;
        }
        if (!Objects.equals(this.eventId, other.eventId)) {
            return false;
        }
        if (this.startMillis != other.startMillis) {
            return false;
        }
        if (!Objects.equals(this.endMillis, other.endMillis)) {
            return false;
        }
        if (!this.annotations.equals(other.annotations)) {
            return false;
        }
        if (!this.customer.equals(other.customer)) {
            return false;
        }
        if (!this.hosts.equals(other.hosts)) {
            return false;
        }
        return this.details.equals(other.details);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@Event").append(' ');
        sb.append(this.getStartMillis()).append(' ');
        if (this.getEndMillis() != null) {
            sb.append(this.getEndMillis());
        }
        sb.append(' ');
        SerializerUtils.appendQuoted(sb, this.getGroup());
        sb.append(' ');
        SerializerUtils.appendQuoted(sb, this.getEventId());
        sb.append(' ');
        SerializerUtils.appendQuoted(sb, this.getCustomer());
        SerializerUtils.appendTags(sb, "host", this.getHosts());
        if (this.getAnnotations() != null) {
            SerializerUtils.appendAnnotations(sb, this.getAnnotations());
        }
        if (this.getDetails() != null) {
            SerializerUtils.appendQuoted(sb, this.getDetails());
        }
        return sb.toString();
    }
}

