/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import wavefront.report.Annotation;

public abstract class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static SetMultimap<String, String> toMultimap(@Nullable Collection<Annotation> annotations) {
        if (annotations == null) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Annotation annotation : annotations) {
            builder.put((Object)annotation.getKey(), (Object)annotation.getValue());
        }
        return builder.build();
    }

    public static List<Annotation> toAnnotationList(@Nullable Multimap<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return ImmutableList.of();
        }
        return tags.entries().stream().map(t -> new Annotation((String)t.getKey(), (String)t.getValue())).collect(Collectors.toList());
    }

    public static List<Annotation> toAnnotationList(@Nullable Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return ImmutableList.of();
        }
        return tags.entrySet().stream().map(t -> new Annotation((String)t.getKey(), (String)t.getValue())).collect(Collectors.toList());
    }

    @Nullable
    public static String getValue(List<Annotation> annotations, String key) {
        return annotations.stream().filter(x -> x.getKey().equals(key)).findFirst().map(Annotation::getValue).orElse(null);
    }
}

