/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common.logger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.wavefront.common.logger.DelegatingLogger;
import com.wavefront.data.ReportableEntityType;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SamplingLogger
extends DelegatingLogger {
    private static final Random RANDOM = new Random();
    private final ReportableEntityType entityType;
    private final double samplingRate;
    private final boolean alwaysActive;
    private final Consumer<String> statusChangeConsumer;
    private final AtomicBoolean loggingActive = new AtomicBoolean(false);

    public SamplingLogger(ReportableEntityType entityType, Logger delegate, double samplingRate, boolean alwaysActive, @Nullable Consumer<String> statusChangeConsumer) {
        super(delegate);
        Preconditions.checkArgument((samplingRate >= 0.0 ? 1 : 0) != 0, (Object)"Sampling rate should be positive!");
        Preconditions.checkArgument((samplingRate <= 1.0 ? 1 : 0) != 0, (Object)"Sampling rate should not be be > 1!");
        this.entityType = entityType;
        this.samplingRate = samplingRate;
        this.alwaysActive = alwaysActive;
        this.statusChangeConsumer = statusChangeConsumer;
        this.refreshLoggerState();
        new Timer("Timer-sampling-logger-" + delegate.getName()).scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SamplingLogger.this.refreshLoggerState();
            }
        }, 1000L, 1000L);
    }

    @Override
    public boolean isLoggable(Level level) {
        if (level == Level.FINEST) {
            return (this.alwaysActive || this.loggingActive.get()) && (this.samplingRate >= 1.0 || this.samplingRate > 0.0 && RANDOM.nextDouble() < this.samplingRate);
        }
        return this.delegate.isLoggable(level);
    }

    @Override
    public void log(Level level, String message) {
        if ((this.alwaysActive || this.loggingActive.get()) && (this.samplingRate >= 1.0 || this.samplingRate > 0.0 && RANDOM.nextDouble() < this.samplingRate)) {
            this.log(new LogRecord(level, message));
        }
    }

    @VisibleForTesting
    void refreshLoggerState() {
        boolean finestLoggable = this.delegate.isLoggable(Level.FINEST);
        if (this.loggingActive.compareAndSet(!finestLoggable, finestLoggable) && this.statusChangeConsumer != null) {
            String status = this.loggingActive.get() ? "enabled with " + this.samplingRate * 100.0 + "% sampling" : "disabled";
            this.statusChangeConsumer.accept("Valid " + this.entityType.toString() + " logging is now " + status);
        }
    }
}

