/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.math.LongMath;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.RecyclableRateLimiter;
import java.util.concurrent.TimeUnit;

public class RecyclableRateLimiterImpl
extends RateLimiter
implements RecyclableRateLimiter {
    private double storedPermits;
    private double maxPermits;
    private double stableIntervalMicros;
    private long nextFreeTicketMicros = 0L;
    private final double maxBurstSeconds;
    private final RateLimiter.SleepingStopwatch stopwatch;
    private final Object mutex = new Object();

    public static RecyclableRateLimiter create(double permitsPerSecond, double maxBurstSeconds) {
        return new RecyclableRateLimiterImpl(RateLimiter.SleepingStopwatch.createFromSystemTimer(), permitsPerSecond, maxBurstSeconds);
    }

    private RecyclableRateLimiterImpl(RateLimiter.SleepingStopwatch stopwatch, double permitsPerSecond, double maxBurstSeconds) {
        super(stopwatch);
        this.stopwatch = stopwatch;
        this.maxBurstSeconds = maxBurstSeconds;
        this.setRate(permitsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getAvailablePermits() {
        Object object = this.mutex;
        synchronized (object) {
            this.resync(this.stopwatch.readMicros());
            return this.storedPermits;
        }
    }

    @Override
    public boolean immediatelyAvailable(int permits) {
        return this.getAvailablePermits() >= (double)permits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recyclePermits(int permits) {
        Object object = this.mutex;
        synchronized (object) {
            long nowMicros = this.stopwatch.readMicros();
            this.resync(nowMicros);
            long surplusPermits = (long)permits - (long)((double)(this.nextFreeTicketMicros - nowMicros) / this.stableIntervalMicros);
            long waitMicros = -Math.min((long)((double)surplusPermits * this.stableIntervalMicros), 0L);
            try {
                this.nextFreeTicketMicros = LongMath.checkedAdd((long)nowMicros, (long)waitMicros);
            }
            catch (ArithmeticException e) {
                this.nextFreeTicketMicros = Long.MAX_VALUE;
            }
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + (double)Math.max(surplusPermits, 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doSetRate(double permitsPerSecond, long nowMicros) {
        Object object = this.mutex;
        synchronized (object) {
            this.resync(nowMicros);
            this.stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / permitsPerSecond;
            double oldMaxPermits = this.maxPermits;
            this.maxPermits = this.maxBurstSeconds * permitsPerSecond;
            this.storedPermits = oldMaxPermits == Double.POSITIVE_INFINITY ? this.maxPermits : (oldMaxPermits == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / oldMaxPermits);
        }
    }

    final double doGetRate() {
        return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long queryEarliestAvailable(long nowMicros) {
        Object object = this.mutex;
        synchronized (object) {
            return this.nextFreeTicketMicros;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
        Object object = this.mutex;
        synchronized (object) {
            this.resync(nowMicros);
            long returnValue = this.nextFreeTicketMicros;
            double storedPermitsToSpend = Math.min((double)requiredPermits, this.storedPermits);
            double freshPermits = (double)requiredPermits - storedPermitsToSpend;
            long waitMicros = (long)(freshPermits * this.stableIntervalMicros);
            try {
                this.nextFreeTicketMicros = LongMath.checkedAdd((long)this.nextFreeTicketMicros, (long)waitMicros);
            }
            catch (ArithmeticException e) {
                this.nextFreeTicketMicros = Long.MAX_VALUE;
            }
            this.storedPermits -= storedPermitsToSpend;
            return returnValue;
        }
    }

    private void resync(long nowMicros) {
        if (nowMicros > this.nextFreeTicketMicros) {
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + (double)(nowMicros - this.nextFreeTicketMicros) / this.stableIntervalMicros);
            this.nextFreeTicketMicros = nowMicros;
        }
    }
}

