/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.MetricConstants;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;

public class DeltaCounter
extends Counter {
    private DeltaCounter() {
    }

    @VisibleForTesting
    public static synchronized DeltaCounter get(MetricsRegistry registry, MetricName metricName) {
        if (registry == null || metricName == null || metricName.getName().isEmpty()) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        DeltaCounter counter = new DeltaCounter();
        MetricName newMetricName = DeltaCounter.getDeltaCounterMetricName(metricName);
        registry.getOrAdd(newMetricName, (Metric)counter);
        return counter;
    }

    public static DeltaCounter get(MetricName metricName) {
        return DeltaCounter.get(Metrics.defaultRegistry(), metricName);
    }

    public static long processDeltaCounter(DeltaCounter counter) {
        long count = counter.count();
        counter.dec(count);
        return count;
    }

    public static MetricName getDeltaCounterMetricName(MetricName metricName) {
        if (DeltaCounter.isDelta(metricName.getName())) {
            return metricName;
        }
        String name = DeltaCounter.getDeltaCounterName(metricName.getName());
        return new MetricName(metricName.getGroup(), metricName.getType(), name, metricName.getScope());
    }

    public static String getDeltaCounterName(String name) {
        if (!DeltaCounter.isDelta(name)) {
            return MetricConstants.DELTA_PREFIX + name;
        }
        return name;
    }

    public static boolean isDelta(String name) {
        return name.startsWith(MetricConstants.DELTA_PREFIX) || name.startsWith(MetricConstants.DELTA_PREFIX_2);
    }

    public static String getNameWithoutDeltaPrefix(String name) {
        if (name.startsWith(MetricConstants.DELTA_PREFIX)) {
            return name.substring(MetricConstants.DELTA_PREFIX.length());
        }
        if (name.startsWith(MetricConstants.DELTA_PREFIX_2)) {
            return name.substring(MetricConstants.DELTA_PREFIX_2.length());
        }
        return name;
    }
}

