/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;

public abstract class SerializerUtils {
    private static final String DOUBLE_QUOTE = "\"";
    private static final String ESCAPED_DOUBLE_QUOTE = "\\\"";

    public static StringBuilder appendQuoted(StringBuilder sb, String raw) {
        return sb.append(DOUBLE_QUOTE).append(SerializerUtils.escapeQuotes(raw)).append(DOUBLE_QUOTE);
    }

    public static StringBuilder appendTagMap(StringBuilder sb, @Nullable Map<String, String> tags) {
        if (tags != null) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                sb.append(' ');
                SerializerUtils.appendQuoted(sb, entry.getKey()).append('=');
                SerializerUtils.appendQuoted(sb, entry.getValue());
            }
        }
        return sb;
    }

    public static StringBuilder appendAnnotations(StringBuilder sb, @Nullable List<Annotation> annotations) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                sb.append(' ');
                SerializerUtils.appendQuoted(sb, annotation.getKey()).append('=');
                SerializerUtils.appendQuoted(sb, annotation.getValue());
            }
        }
        return sb;
    }

    public static StringBuilder appendTags(StringBuilder sb, String tagKey, @Nullable List<String> tagValues) {
        if (tagValues != null) {
            for (String tag : tagValues) {
                sb.append(' ');
                SerializerUtils.appendQuoted(sb, tagKey).append('=');
                SerializerUtils.appendQuoted(sb, tag);
            }
        }
        return sb;
    }

    private static String escapeQuotes(String raw) {
        return StringUtils.replace((String)raw, (String)DOUBLE_QUOTE, (String)ESCAPED_DOUBLE_QUOTE);
    }
}

