/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.cms.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.volcengine.error.SdkError;
import com.volcengine.model.ServiceInfo;
import com.volcengine.model.beans.cms.BaseResp;
import com.volcengine.model.request.ArticleFeedRequest;
import com.volcengine.model.request.ArticleGetGoodsRelatedRequest;
import com.volcengine.model.request.ArticleGetVideoRequest;
import com.volcengine.model.request.ArticleMGetGoodsRelatedRequest;
import com.volcengine.model.request.ArticleMGetVideoRequest;
import com.volcengine.model.request.ArticleRelatedFeedRequest;
import com.volcengine.model.request.ArticleSearchRequest;
import com.volcengine.model.response.ArticleFeedResponse;
import com.volcengine.model.response.ArticleGetGoodsRelatedResponse;
import com.volcengine.model.response.ArticleGetVideoResponse;
import com.volcengine.model.response.ArticleMGetGoodsRelatedResponse;
import com.volcengine.model.response.ArticleMGetVideoResponse;
import com.volcengine.model.response.ArticleRelatedFeedResponse;
import com.volcengine.model.response.ArticleSearchResponse;
import com.volcengine.model.response.RawResponse;
import com.volcengine.model.response.ResponseMetadata;
import com.volcengine.service.BaseServiceImpl;
import com.volcengine.service.cms.CmsApiService;
import com.volcengine.service.cms.CmsConfig;
import java.util.ArrayList;
import org.apache.http.NameValuePair;

public class CmsApiServiceImpl
extends BaseServiceImpl
implements CmsApiService {
    public CmsApiServiceImpl() {
        super(CmsConfig.apiServiceInfoMap.get("cn-north-1"), CmsConfig.apiApiInfoMap);
    }

    public CmsApiServiceImpl(ServiceInfo serviceInfo) {
        super(serviceInfo, CmsConfig.apiApiInfoMap);
    }

    public CmsApiServiceImpl(String accessKey, String secretKey) {
        this();
        if (!accessKey.equals("")) {
            this.setAccessKey(accessKey);
        }
        if (!secretKey.equals("")) {
            this.setSecretKey(secretKey);
        }
    }

    public static CmsApiService getInstance() {
        return new CmsApiServiceImpl();
    }

    public static CmsApiService getInstance(String region) throws Exception {
        ServiceInfo serviceInfo = CmsConfig.apiServiceInfoMap.get(region);
        if (serviceInfo == null) {
            throw new Exception("Edit not support region " + region);
        }
        return new CmsApiServiceImpl(serviceInfo);
    }

    @Override
    public ArticleFeedResponse feed(ArticleFeedRequest articleFeedRequest) throws Exception {
        RawResponse response = this.json("Feed", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleFeedRequest));
        return this.getFeedResult(response);
    }

    @Override
    public ArticleGetVideoResponse getVideoByVid(ArticleGetVideoRequest articleGetVideoRequest) throws Exception {
        RawResponse response = this.json("GetVideoByVid", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)articleGetVideoRequest));
        return this.getVideoResult(response);
    }

    @Override
    public ArticleMGetVideoResponse mGetVideoByVids(ArticleMGetVideoRequest mGetVideoRequest) throws Exception {
        RawResponse response = this.json("MGetVideoByVids", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)mGetVideoRequest));
        return this.mGetVideoResult(response);
    }

    @Override
    public ArticleGetGoodsRelatedResponse getGoodsRelatedArticles(ArticleGetGoodsRelatedRequest getGoodsRelatedArticlesRequest) throws Exception {
        RawResponse response = this.json("GetGoodsRelatedArticles", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)getGoodsRelatedArticlesRequest));
        return this.getGoodsRelatedArticlesResult(response);
    }

    @Override
    public ArticleMGetGoodsRelatedResponse mGetGoodsRelatedArticles(ArticleMGetGoodsRelatedRequest mGetGoodsRelatedRequest) throws Exception {
        RawResponse response = this.json("MGetGoodsRelatedArticles", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)mGetGoodsRelatedRequest));
        return this.mGetGoodsRelatedArticlesResult(response);
    }

    @Override
    public ArticleSearchResponse articleSearch(ArticleSearchRequest searchRequest) throws Exception {
        RawResponse response = this.json("Search", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)searchRequest));
        return this.articleSearchResult(response);
    }

    @Override
    public ArticleRelatedFeedResponse relatedFeed(ArticleRelatedFeedRequest relatedFeedRequest) throws Exception {
        RawResponse response = this.json("RelatedFeed", new ArrayList<NameValuePair>(), JSON.toJSONString((Object)relatedFeedRequest));
        return this.relatedFeedResult(response);
    }

    private ArticleFeedResponse getFeedResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleFeedResponse res = (ArticleFeedResponse)JSON.parseObject((byte[])response.getData(), ArticleFeedResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        if (res.getBaseResp() != null && res.getBaseResp().getStatusCode() != 1000) {
            ArticleFeedResponse.BaseResp baseResp = res.getBaseResp();
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
        return res;
    }

    private ArticleGetVideoResponse getVideoResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleGetVideoResponse res = (ArticleGetVideoResponse)JSON.parseObject((byte[])response.getData(), ArticleGetVideoResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        if (res.getBaseResp() != null && res.getBaseResp().getStatusCode() != 1000) {
            ArticleGetVideoResponse.BaseResp baseResp = res.getBaseResp();
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
        return res;
    }

    private ArticleMGetVideoResponse mGetVideoResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleMGetVideoResponse res = (ArticleMGetVideoResponse)JSON.parseObject((byte[])response.getData(), ArticleMGetVideoResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        if (res.getBaseResp() != null && res.getBaseResp().getStatusCode() != 1000) {
            ArticleMGetVideoResponse.BaseResp baseResp = res.getBaseResp();
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
        return res;
    }

    private ArticleGetGoodsRelatedResponse getGoodsRelatedArticlesResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleGetGoodsRelatedResponse res = (ArticleGetGoodsRelatedResponse)JSON.parseObject((byte[])response.getData(), ArticleGetGoodsRelatedResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        this.checkBaseResp(res.getBaseResp());
        return res;
    }

    private ArticleMGetGoodsRelatedResponse mGetGoodsRelatedArticlesResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleMGetGoodsRelatedResponse res = (ArticleMGetGoodsRelatedResponse)JSON.parseObject((byte[])response.getData(), ArticleMGetGoodsRelatedResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        this.checkBaseResp(res.getBaseResp());
        return res;
    }

    private ArticleSearchResponse articleSearchResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleSearchResponse res = (ArticleSearchResponse)JSON.parseObject((byte[])response.getData(), ArticleSearchResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        this.checkBaseResp(res.getBaseResp());
        return res;
    }

    private ArticleRelatedFeedResponse relatedFeedResult(RawResponse response) throws Exception {
        if (response.getCode() != SdkError.SUCCESS.getNumber()) {
            throw response.getException();
        }
        ArticleRelatedFeedResponse res = (ArticleRelatedFeedResponse)JSON.parseObject((byte[])response.getData(), ArticleRelatedFeedResponse.class, (Feature[])new Feature[0]);
        this.checkResponseMetadata(res.getResponseMetadata());
        this.checkBaseResp(res.getBaseResp());
        return res;
    }

    private void checkResponseMetadata(ResponseMetadata metadata) throws Exception {
        if (metadata != null && metadata.getError() != null) {
            throw new Exception(metadata.getRequestId() + " error: " + metadata.getError().getMessage());
        }
    }

    private void checkBaseResp(BaseResp baseResp) throws Exception {
        if (baseResp != null && baseResp.getStatusCode() != 1000) {
            throw new Exception("error: " + baseResp.getStatusMessage());
        }
    }
}

