/*
 * Decompiled with CFR 0.152.
 */
package com.vincenzoracca.webflux.mdc.filter;

import com.vincenzoracca.webflux.mdc.config.SpringMDCProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Component
public class MDCFilter
implements WebFilter {
    private final SpringMDCProperties mdcProperties;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        HashMap mapInContext = new HashMap();
        if (!this.mdcProperties.getHeaders().isEmpty()) {
            HttpHeaders requestHeaders = exchange.getRequest().getHeaders();
            Map<String, String> headersForMDC = this.mdcProperties.getHeaders();
            List<String> defaults = this.mdcProperties.getDefaults();
            headersForMDC.forEach((headerForMDCKey, headerForMDCValue) -> {
                if (requestHeaders.containsKey(headerForMDCKey)) {
                    mapInContext.put(headerForMDCValue, requestHeaders.get(headerForMDCKey).get(0));
                } else if (defaults.contains(headerForMDCKey)) {
                    mapInContext.put(headerForMDCValue, UUID.randomUUID().toString());
                }
            });
        }
        if (!mapInContext.isEmpty()) {
            return Mono.defer(() -> chain.filter(exchange)).contextWrite((ContextView)Context.of(mapInContext));
        }
        return chain.filter(exchange);
    }

    public MDCFilter(SpringMDCProperties mdcProperties) {
        this.mdcProperties = mdcProperties;
    }
}

