/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.utils;

import com.ververica.cdc.debezium.DebeziumSourceFunction;
import io.debezium.data.Envelope;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class AssertUtils {
    public static void assertInsert(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assert.assertNotNull((Object)record.key());
            Assert.assertNotNull((Object)record.keySchema());
        } else {
            Assert.assertNull((Object)record.key());
            Assert.assertNull((Object)record.keySchema());
        }
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)Envelope.Operation.CREATE.code(), (Object)value.getString("op"));
        Assert.assertNotNull((Object)value.get("after"));
        Assert.assertNull((Object)value.get("before"));
    }

    public static void assertRead(SourceRecord record) {
        Assert.assertNotNull((Object)record.key());
        Assert.assertNotNull((Object)record.keySchema());
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)Envelope.Operation.READ.code(), (Object)value.getString("op"));
        Assert.assertNotNull((Object)value.get("after"));
        Assert.assertNull((Object)value.get("before"));
    }

    public static void assertUpdate(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assert.assertNotNull((Object)record.key());
            Assert.assertNotNull((Object)record.keySchema());
        } else {
            Assert.assertNull((Object)record.key());
            Assert.assertNull((Object)record.keySchema());
        }
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)Envelope.Operation.UPDATE.code(), (Object)value.getString("op"));
        Assert.assertNotNull((Object)value.get("after"));
    }

    public static void assertDelete(SourceRecord record, boolean keyExpected) {
        if (keyExpected) {
            Assert.assertNotNull((Object)record.key());
            Assert.assertNotNull((Object)record.keySchema());
        } else {
            Assert.assertNull((Object)record.key());
            Assert.assertNull((Object)record.keySchema());
        }
        Assert.assertNotNull((Object)record.valueSchema());
        Struct value = (Struct)record.value();
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)Envelope.Operation.DELETE.code(), (Object)value.getString("op"));
        Assert.assertNotNull((Object)value.get("before"));
        Assert.assertNull((Object)value.get("after"));
    }

    public static void assertTombstone(SourceRecord record) {
        Assert.assertNotNull((Object)record.key());
        Assert.assertNotNull((Object)record.keySchema());
        Assert.assertNull((Object)record.value());
        Assert.assertNull((Object)record.valueSchema());
    }

    public static void hasValidKey(SourceRecord record, String pkField, int pk) {
        Struct key = (Struct)record.key();
        Assert.assertEquals((Object)pk, (Object)key.get(pkField));
    }

    public static void assertInsert(SourceRecord record) {
        AssertUtils.assertInsert(record, false);
    }

    public static void assertInsert(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertInsert(record, true);
    }

    public static void assertRead(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertRead(record);
    }

    public static void assertUpdate(SourceRecord record) {
        AssertUtils.assertUpdate(record, false);
    }

    public static void assertUpdate(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertUpdate(record, true);
    }

    public static void assertDelete(SourceRecord record) {
        AssertUtils.assertDelete(record, false);
    }

    public static void assertDelete(SourceRecord record, String pkField, int pk) {
        AssertUtils.hasValidKey(record, pkField, pk);
        AssertUtils.assertDelete(record, true);
    }

    public static void assertProducedTypeOfSourceFunction(DebeziumSourceFunction<RowData> debeziumSourceFunction, DataType expectedProducedType) {
        TypeInformation producedType = debeziumSourceFunction.getProducedType();
        MatcherAssert.assertThat((Object)producedType, (Matcher)CoreMatchers.instanceOf(InternalTypeInfo.class));
        InternalTypeInfo rowDataInternalTypeInfo = (InternalTypeInfo)producedType;
        DataType producedDataType = rowDataInternalTypeInfo.getDataType();
        Assert.assertEquals((Object)expectedProducedType.toString(), (Object)producedDataType.toString());
    }
}

