/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.screenshot;

import java.awt.image.BufferedImage;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ImageComparisonUtil {
    public static String generateImageHash(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] data = new byte[width * height * 3];
        int idx = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                data[idx++] = (byte)((rgb &= 0xFCFCFC) >> 16);
                data[idx++] = (byte)(rgb >> 8);
                data[idx++] = (byte)rgb;
            }
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(data);
            String hash = ImageComparisonUtil.byteToHex(md5.digest());
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 algorithm provider not found", e);
        }
    }

    private static String byteToHex(byte[] bytes) {
        String hex = "";
        for (int i = 0; i < bytes.length; ++i) {
            hex = hex + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
        }
        return hex;
    }

    public static int getNrBlocks(int pixels) {
        return (int)Math.floor(pixels + 15) / 16;
    }
}

