/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench.parallel;

import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import com.vaadin.testbench.parallel.TestBenchBrowserFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserUtil {
    private static TestBenchBrowserFactory browserFactory = new DefaultBrowserFactory();

    public static DesiredCapabilities safari() {
        DesiredCapabilities c = browserFactory.create(Browser.SAFARI);
        return c;
    }

    public static DesiredCapabilities chrome() {
        DesiredCapabilities c = browserFactory.create(Browser.CHROME);
        return c;
    }

    public static DesiredCapabilities firefox() {
        DesiredCapabilities c = browserFactory.create(Browser.FIREFOX);
        return c;
    }

    public static DesiredCapabilities ie11() {
        DesiredCapabilities c = browserFactory.create(Browser.IE11);
        return c;
    }

    public static DesiredCapabilities edge() {
        DesiredCapabilities c = browserFactory.create(Browser.EDGE);
        return c;
    }

    public static boolean isIE(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return "internet explorer".equals(capabilities.getBrowserName());
    }

    public static boolean isIE(Capabilities capabilities, int version) {
        if (capabilities == null) {
            return false;
        }
        return BrowserUtil.isIE(capabilities) && ("" + version).equals(capabilities.getVersion());
    }

    public static boolean isEdge(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return "MicrosoftEdge".equals(capabilities.getBrowserName());
    }

    public static boolean isChrome(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return "chrome".equals(capabilities.getBrowserName());
    }

    public static boolean isSafari(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return "safari".equals(capabilities.getBrowserName());
    }

    public static boolean isFirefox(Capabilities capabilities) {
        if (capabilities == null) {
            return false;
        }
        return "firefox".equals(capabilities.getBrowserName());
    }

    public static String getBrowserIdentifier(Capabilities capabilities) {
        if (BrowserUtil.isIE(capabilities)) {
            return "InternetExplorer";
        }
        if (BrowserUtil.isFirefox(capabilities)) {
            return "Firefox";
        }
        if (BrowserUtil.isChrome(capabilities)) {
            return "Chrome";
        }
        if (BrowserUtil.isSafari(capabilities)) {
            return "Safari";
        }
        if (BrowserUtil.isEdge(capabilities)) {
            return "Edge";
        }
        if (capabilities == null) {
            return "Unknown";
        }
        return capabilities.getBrowserName();
    }

    public static String getPlatform(Capabilities capabilities) {
        if (capabilities == null) {
            return "Unknown";
        }
        try {
            Platform p = capabilities.getPlatform();
            if (p == Platform.WIN8 || p == Platform.WINDOWS || p == Platform.VISTA || p == Platform.XP) {
                return "Windows";
            }
            if (p == Platform.MAC) {
                return "Mac";
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        Object rawPlatform = capabilities.getCapability("platform");
        if (rawPlatform == null) {
            return "Unknown";
        }
        return rawPlatform.toString();
    }

    static void setBrowserFactory(TestBenchBrowserFactory browserFactory) {
        BrowserUtil.browserFactory = browserFactory;
    }

    public static TestBenchBrowserFactory getBrowserFactory() {
        return browserFactory;
    }
}

