/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.spring.server;

import com.vaadin.server.DefaultUIProvider;
import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionDestroyEvent;
import com.vaadin.server.SessionDestroyListener;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletService;
import com.vaadin.server.VaadinSession;
import com.vaadin.spring.internal.UIScopeImpl;
import com.vaadin.spring.internal.VaadinSessionScope;
import com.vaadin.spring.server.SpringUIProvider;
import com.vaadin.spring.server.SpringVaadinServletRequest;
import com.vaadin.spring.server.SpringVaadinServletService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringVaadinServlet
extends VaadinServlet {
    private static final long serialVersionUID = 5371983676318947478L;
    private String serviceUrlPath = null;

    protected void servletInitialized() throws ServletException {
        VaadinServletService service = this.getService();
        service.addSessionInitListener(new SessionInitListener(){
            private static final long serialVersionUID = -6307820453486668084L;

            public void sessionInit(SessionInitEvent sessionInitEvent) throws ServiceException {
                WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SpringVaadinServlet.this.getServletContext());
                VaadinSession session = sessionInitEvent.getSession();
                ArrayList uiProviders = new ArrayList(session.getUIProviders());
                for (UIProvider provider : uiProviders) {
                    if (!DefaultUIProvider.class.getCanonicalName().equals(provider.getClass().getCanonicalName())) continue;
                    session.removeUIProvider(provider);
                }
                SpringUIProvider uiProvider = new SpringUIProvider(session);
                session.addUIProvider((UIProvider)uiProvider);
            }
        });
        service.addSessionDestroyListener(new SessionDestroyListener(){

            public void sessionDestroy(SessionDestroyEvent event) {
                VaadinSession session = event.getSession();
                UIScopeImpl.cleanupSession(session);
                VaadinSessionScope.cleanupSession(session);
            }
        });
    }

    public String getServiceUrlPath() {
        return this.serviceUrlPath;
    }

    public void setServiceUrlPath(String serviceUrlPath) {
        this.serviceUrlPath = serviceUrlPath;
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        SpringVaadinServletService service = new SpringVaadinServletService(this, deploymentConfiguration, this.getServiceUrlPath());
        service.init();
        return service;
    }

    protected VaadinServletRequest createVaadinRequest(HttpServletRequest request) {
        if (this.serviceUrlPath != null) {
            return new SpringVaadinServletRequest(request, this.getService(), true);
        }
        return new VaadinServletRequest(request, this.getService());
    }

    protected String getStaticFilePath(HttpServletRequest request) {
        String staticFilePath = super.getStaticFilePath(request);
        if (staticFilePath == null) {
            try {
                String decodedRequestURI = URLDecoder.decode(request.getRequestURI(), StandardCharsets.UTF_8.name());
                if (decodedRequestURI.startsWith("/VAADIN/")) {
                    return decodedRequestURI;
                }
                String decodedContextPath = URLDecoder.decode(request.getContextPath(), StandardCharsets.UTF_8.name());
                if (decodedRequestURI.startsWith(decodedContextPath + "/VAADIN/")) {
                    return decodedRequestURI.substring(decodedContextPath.length());
                }
            }
            catch (UnsupportedEncodingException exception) {
                throw new RuntimeException(exception);
            }
        }
        return staticFilePath;
    }
}

