/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.grid.ColumnBase;
import com.vaadin.flow.component.grid.ColumnGroup;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.HtmlUtils;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

abstract class AbstractColumn<T extends AbstractColumn<T>>
extends Component
implements ColumnBase<T> {
    protected final Grid<?> grid;
    protected Element headerTemplate;
    protected Element footerTemplate;
    private Renderer<?> headerRenderer;
    private Renderer<?> footerRenderer;
    private boolean headerRenderingScheduled;
    private boolean footerRenderingScheduled;
    private boolean sortingIndicators;
    private String headerText;
    private Component headerComponent;
    private String footerText;
    private Component footerComponent;

    public AbstractColumn(Grid<?> grid) {
        this.grid = grid;
        this.addAttachListener((ComponentEventListener & Serializable)e -> {
            this.scheduleHeaderRendering();
            this.scheduleFooterRendering();
        });
    }

    public Grid<?> getGrid() {
        return this.grid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Deprecated
    protected void setHeaderRenderer(Renderer<?> renderer) {
        this.headerRenderer = renderer;
        this.scheduleHeaderRendering();
    }

    private void scheduleHeaderRendering() {
        if (this.headerRenderingScheduled) {
            return;
        }
        this.headerRenderingScheduled = true;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            if (!this.headerRenderingScheduled) {
                return;
            }
            this.renderHeader();
            this.headerRenderingScheduled = false;
        }));
    }

    private Rendering<?> renderHeader() {
        if (this.headerTemplate != null) {
            this.headerTemplate.removeFromParent();
            this.headerTemplate = null;
        }
        if (this.headerRenderer == null) {
            return null;
        }
        Rendering rendering = this.headerRenderer.render(this.getElement(), null);
        this.headerTemplate = rendering.getTemplateElement();
        this.headerTemplate.setAttribute("class", "header");
        if (this.hasSortingIndicators()) {
            this.headerTemplate.setProperty("innerHTML", this.addGridSorter(this.headerTemplate.getProperty("innerHTML")));
        }
        return rendering;
    }

    private void scheduleFooterRendering() {
        if (this.footerRenderingScheduled) {
            return;
        }
        this.footerRenderingScheduled = true;
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            if (!this.footerRenderingScheduled) {
                return;
            }
            this.renderFooter();
            this.footerRenderingScheduled = false;
        }));
    }

    @Deprecated
    protected void setFooterRenderer(Renderer<?> renderer) {
        this.footerRenderer = renderer;
        this.scheduleFooterRendering();
    }

    private Rendering<?> renderFooter() {
        if (this.footerTemplate != null) {
            this.footerTemplate.removeFromParent();
            this.footerTemplate = null;
        }
        if (this.footerRenderer == null) {
            return null;
        }
        Rendering rendering = this.footerRenderer.render(this.getElement(), null);
        this.footerTemplate = rendering.getTemplateElement();
        this.footerTemplate.setAttribute("class", "footer");
        return rendering;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    protected void setHeaderText(String text) {
        this.headerText = text;
        this.headerComponent = null;
        this.setHeaderRenderer((Renderer<?>)TemplateRenderer.of((String)(text != null ? HtmlUtils.escape((String)text) : "")));
    }

    public String getFooterText() {
        return this.footerText;
    }

    protected void setFooterText(String text) {
        this.footerText = text;
        this.footerComponent = null;
        this.setFooterRenderer((Renderer<?>)TemplateRenderer.of((String)(text != null ? HtmlUtils.escape((String)text) : "")));
    }

    public Component getHeaderComponent() {
        return this.headerComponent;
    }

    protected void setHeaderComponent(Component component) {
        this.headerText = null;
        this.headerComponent = component;
        this.setHeaderRenderer((Renderer<?>)new ComponentRenderer((SerializableSupplier & Serializable)() -> component));
    }

    public Component getFooterComponent() {
        return this.footerComponent;
    }

    protected void setFooterComponent(Component component) {
        this.footerText = null;
        this.footerComponent = component;
        this.setFooterRenderer((Renderer<?>)new ComponentRenderer((SerializableSupplier & Serializable)() -> component));
    }

    @Deprecated
    protected Renderer<?> getHeaderRenderer() {
        return this.headerRenderer;
    }

    @Deprecated
    protected Renderer<?> getFooterRenderer() {
        return this.footerRenderer;
    }

    protected void moveHeaderContent(AbstractColumn<?> otherColumn) {
        if (this.headerComponent != null) {
            otherColumn.setHeaderComponent(this.headerComponent);
        } else {
            otherColumn.setHeaderText(this.headerText);
        }
    }

    protected void moveFooterContent(AbstractColumn<?> otherColumn) {
        if (this.footerComponent != null) {
            otherColumn.setFooterComponent(this.footerComponent);
        } else {
            otherColumn.setFooterText(this.footerText);
        }
    }

    protected void updateSortingIndicators(boolean sortable) {
        if (sortable) {
            this.setSortingIndicators(this.getBottomLevelColumn().isSortable());
        } else {
            this.setSortingIndicators(false);
        }
    }

    protected void setSortingIndicators(boolean sortingIndicators) {
        if (this.sortingIndicators == sortingIndicators) {
            return;
        }
        this.sortingIndicators = sortingIndicators;
        this.scheduleHeaderRendering();
    }

    protected boolean hasSortingIndicators() {
        return this.sortingIndicators;
    }

    protected String addGridSorter(String templateInnerHtml) {
        String textContent;
        String escapedColumnId = HtmlUtils.escape((String)this.getBottomLevelColumn().getInternalId());
        String string = textContent = this.headerComponent != null ? this.headerComponent.getElement().getTextRecursively() : this.headerText;
        if (textContent != null) {
            textContent = HtmlUtils.escape((String)textContent);
        }
        String sortBy = textContent == null || textContent.isBlank() ? "" : "aria-label='Sort by " + textContent + "'";
        return String.format("<vaadin-grid-sorter path='%s' %s>%s</vaadin-grid-sorter>", escapedColumnId, sortBy, templateInnerHtml);
    }

    protected abstract Grid.Column<?> getBottomLevelColumn();

    protected List<Grid.Column<?>> getBottomChildColumns() {
        List<Grid.Column<?>> columnChildren = this.getChildren().filter(child -> child instanceof Grid.Column).map(child -> (Grid.Column)child).collect(Collectors.toList());
        columnChildren.addAll(this.getChildren().filter(child -> child instanceof ColumnGroup).flatMap(child -> ((ColumnGroup)child).getBottomChildColumns().stream()).collect(Collectors.toList()));
        return columnChildren;
    }
}

