/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

class FieldValidationUtil {
    private FieldValidationUtil() {
    }

    static <T> void disableClientValidation(CheckboxGroup<T> component) {
        if (!component.isAttached()) {
            throw new IllegalStateException(String.format("Component %s is not attached. Client side validation should be disabled when the component is attached, thus this method needs to be called from the onAttach method of the component.", new Object[]{component}));
        }
        component.getUI().ifPresent(ui -> ui.beforeClientResponse((Component)component, (SerializableConsumer & Serializable)executionContext -> FieldValidationUtil.overrideClientValidation(component)));
    }

    private static <T> void overrideClientValidation(CheckboxGroup<T> component) {
        StringBuilder expression = new StringBuilder("this.validate = function () {return !(this.required && this.value.length === 0);};");
        if (component.isInvalid()) {
            expression.append("this.invalid = true;");
        }
        component.getElement().executeJs(expression.toString(), new Serializable[0]);
    }
}

