/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.hilla.engine.EngineConfiguration;
import com.vaadin.hilla.engine.ParserException;
import com.vaadin.hilla.engine.ParserProcessor;
import com.vaadin.hilla.internal.AbstractTaskEndpointGenerator;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGenerateOpenAPIImpl
extends AbstractTaskEndpointGenerator
implements TaskGenerateOpenAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskGenerateOpenAPIImpl.class);
    private final ClassLoader classLoader;
    private final boolean isProductionMode;

    TaskGenerateOpenAPIImpl(File projectDirectory, String buildDirectoryName, File outputDirectory, Function<String, URL> resourceFinder, @Nonnull ClassLoader classLoader, boolean isProductionMode) {
        super(projectDirectory, buildDirectoryName, outputDirectory, resourceFinder);
        this.classLoader = Objects.requireNonNull(classLoader, "ClassLoader should not be null");
        this.isProductionMode = isProductionMode;
    }

    public void execute() throws ExecutionFailedException {
        try {
            EngineConfiguration engineConfiguration = this.getEngineConfiguration();
            ParserProcessor processor = new ParserProcessor(engineConfiguration, this.classLoader, this.isProductionMode);
            processor.process();
        }
        catch (ParserException e) {
            LOGGER.error("Java code parsing failed", (Throwable)e);
            throw new ExecutionFailedException("Java code parsing failed");
        }
    }
}

