/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.internal.ResponseWriter;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.ThemeUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileServer
implements StaticFileHandler {
    static final String PROPERTY_FIX_INCORRECT_WEBJAR_PATHS = "vaadin.fixIncorrectWebjarPaths";
    private static final Pattern INCORRECT_WEBJAR_PATH_REGEX = Pattern.compile("^/frontend[-\\w/]*/webjars/");
    private final ResponseWriter responseWriter;
    private final VaadinService vaadinService;
    private DeploymentConfiguration deploymentConfiguration;
    private DevModeHandler devModeHandler;
    private static final Pattern APP_THEME_PATTERN = Pattern.compile("^\\/VAADIN\\/themes\\/([\\s\\S]+?)\\/");
    public static final Pattern APP_THEME_ASSETS_PATTERN = Pattern.compile("^\\/themes\\/([\\s\\S]+?)\\/");
    static final Map<URI, Integer> openFileSystems = new HashMap<URI, Integer>();
    static final Set<URI> externalFileSystem = new HashSet<URI>();
    private static final Object fileSystemLock = new Object();

    public StaticFileServer(VaadinService vaadinService) {
        this.vaadinService = vaadinService;
        this.deploymentConfiguration = vaadinService.getDeploymentConfiguration();
        this.responseWriter = new ResponseWriter(this.deploymentConfiguration);
        this.devModeHandler = DevModeHandlerManager.getDevModeHandler(vaadinService).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourceIsDirectory(URL resource) {
        if (resource.getPath().endsWith("/")) {
            return true;
        }
        URI resourceURI = null;
        try {
            resourceURI = resource.toURI();
        }
        catch (URISyntaxException e) {
            StaticFileServer.getLogger().debug("Syntax error in uri from getStaticResource", (Throwable)e);
            return false;
        }
        if ("jar".equals(resource.getProtocol())) {
            String pathInJar = resource.getPath().substring(resource.getPath().indexOf(33) + 1);
            try {
                FileSystem fileSystem = this.getFileSystem(resourceURI);
                Path path = fileSystem.getPath(pathInJar, new String[0]);
                boolean bl = Files.isDirectory(path, new LinkOption[0]);
                return bl;
            }
            catch (IOException e) {
                StaticFileServer.getLogger().debug("failed to read jar file contents", (Throwable)e);
            }
            finally {
                this.closeFileSystem(resourceURI);
            }
        }
        return "file".equals(resource.getProtocol()) && Files.isDirectory(Paths.get(resourceURI), new LinkOption[0]);
    }

    private URI getFileURI(URI resourceURI) {
        if (!"jar".equals(resourceURI.getScheme())) {
            return resourceURI;
        }
        try {
            String scheme = resourceURI.getRawSchemeSpecificPart();
            int jarPartIndex = scheme.indexOf("!/");
            if (jarPartIndex != -1) {
                scheme = scheme.substring(0, jarPartIndex);
            }
            return new URI(scheme);
        }
        catch (URISyntaxException syntaxException) {
            throw new IllegalArgumentException(syntaxException.getMessage(), syntaxException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileSystem getFileSystem(URI resourceURI) throws IOException {
        Object object = fileSystemLock;
        synchronized (object) {
            URI fileURI = this.getFileURI(resourceURI);
            if (!fileURI.getScheme().equals("file")) {
                throw new IOException("Can not read scheme '" + fileURI.getScheme() + "' for resource " + resourceURI + " and will determine this as not a folder");
            }
            if (openFileSystems.computeIfPresent(fileURI, (key, value) -> value + 1) != null) {
                return FileSystems.getFileSystem(resourceURI);
            }
            FileSystem fileSystem = this.getNewOrExistingFileSystem(resourceURI);
            openFileSystems.put(fileURI, 1);
            return fileSystem;
        }
    }

    private FileSystem getNewOrExistingFileSystem(URI resourceURI) throws IOException {
        try {
            return FileSystems.newFileSystem(resourceURI, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fsaee) {
            StaticFileServer.getLogger().trace("Tried to get new filesystem, but it already existed for target uri.", (Throwable)fsaee);
            FileSystem fileSystem = FileSystems.getFileSystem(resourceURI);
            URI fileUri = this.getFileURI(resourceURI);
            if (!openFileSystems.containsKey(fileUri)) {
                externalFileSystem.add(fileUri);
            }
            return fileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFileSystem(URI resourceURI) {
        Object object = fileSystemLock;
        synchronized (object) {
            try {
                URI fileURI = this.getFileURI(resourceURI);
                Integer locks = openFileSystems.computeIfPresent(fileURI, (key, value) -> value - 1);
                if (locks != null && locks == 0) {
                    openFileSystems.remove(fileURI);
                    if (!externalFileSystem.contains(fileURI)) {
                        FileSystems.getFileSystem(resourceURI).close();
                    }
                    externalFileSystem.remove(fileURI);
                }
            }
            catch (IOException ioe) {
                StaticFileServer.getLogger().error("Failed to close FileSystem for '{}'", (Object)resourceURI);
                StaticFileServer.getLogger().debug("Exception closing FileSystem", (Throwable)ioe);
            }
        }
    }

    @Override
    public boolean serveStaticResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filenameWithPath = this.getRequestFilename(request);
        if (filenameWithPath.endsWith("/")) {
            return false;
        }
        if (HandlerHelper.isPathUnsafe(filenameWithPath)) {
            StaticFileServer.getLogger().info("Blocked attempt to access file: {}", (Object)filenameWithPath);
            response.setStatus(HttpStatusCode.BAD_REQUEST.getCode());
            return true;
        }
        if (this.devModeHandler != null && !"/index.html".equals(filenameWithPath) && this.devModeHandler.serveDevModeRequest(request, response)) {
            return true;
        }
        URL resourceUrl = null;
        if (this.deploymentConfiguration.getMode() == Mode.DEVELOPMENT_BUNDLE) {
            if (!"/index.html".equals(filenameWithPath)) {
                resourceUrl = DevBundleUtils.findBundleFile(this.deploymentConfiguration.getProjectFolder(), "webapp" + filenameWithPath);
            }
            if (resourceUrl == null && (APP_THEME_PATTERN.matcher(filenameWithPath).find() || APP_THEME_ASSETS_PATTERN.matcher(filenameWithPath).find())) {
                resourceUrl = StaticFileServer.findAssetInFrontendThemesOrDevBundle(this.vaadinService, this.deploymentConfiguration.getProjectFolder(), filenameWithPath.replace("VAADIN/", ""));
            }
        } else if (this.deploymentConfiguration.getMode() == Mode.PRODUCTION_PRECOMPILED_BUNDLE && APP_THEME_PATTERN.matcher(filenameWithPath).find()) {
            resourceUrl = ThemeUtils.getThemeResourceFromPrecompiledProductionBundle(filenameWithPath.replace("VAADIN/", "").replaceFirst("^/", ""));
        } else if (APP_THEME_ASSETS_PATTERN.matcher(filenameWithPath).find()) {
            resourceUrl = this.vaadinService.getClassLoader().getResource("META-INF/VAADIN/webapp/VAADIN/static/" + filenameWithPath.replaceFirst("^/", ""));
        } else if (!"/index.html".equals(filenameWithPath)) {
            resourceUrl = this.vaadinService.getClassLoader().getResource("META-INF/VAADIN/webapp/" + filenameWithPath.replaceFirst("^/", ""));
        }
        if (resourceUrl == null) {
            resourceUrl = this.getStaticResource(filenameWithPath);
        }
        if (resourceUrl == null && this.shouldFixIncorrectWebjarPaths() && this.isIncorrectWebjarPath(filenameWithPath)) {
            resourceUrl = this.getStaticResource(this.fixIncorrectWebjarPath(filenameWithPath));
        }
        if (resourceUrl == null) {
            return false;
        }
        if (this.resourceIsDirectory(resourceUrl)) {
            return false;
        }
        this.writeCacheHeaders(filenameWithPath, response);
        long timestamp = this.writeModificationTimestamp(resourceUrl, request, response);
        if (this.browserHasNewestVersion(request, timestamp)) {
            response.setStatus(HttpStatusCode.NOT_MODIFIED.getCode());
            return true;
        }
        this.responseWriter.writeResponseContents(filenameWithPath, resourceUrl, request, response);
        return true;
    }

    private static URL findAssetInFrontendThemesOrDevBundle(VaadinService vaadinService, File projectFolder, String assetPath) throws IOException {
        File frontendFolder = new File(projectFolder, "frontend/");
        File assetInFrontendThemes = new File(frontendFolder, assetPath);
        if (assetInFrontendThemes.exists()) {
            return assetInFrontendThemes.toURI().toURL();
        }
        File jarResourcesFolder = FrontendUtils.getJarResourcesFolder(frontendFolder);
        assetInFrontendThemes = new File(jarResourcesFolder, assetPath);
        if (assetInFrontendThemes.exists()) {
            return assetInFrontendThemes.toURI().toURL();
        }
        Matcher matcher = APP_THEME_ASSETS_PATTERN.matcher(assetPath);
        if (!matcher.find()) {
            throw new IllegalStateException("Asset path should match the theme pattern");
        }
        String themeName = matcher.group(1);
        String defaultBundleAssetPath = assetPath.replaceFirst(themeName, "vaadin-dev-bundle");
        URL assetInDevBundleUrl = vaadinService.getClassLoader().getResource("vaadin-dev-bundle/assets" + defaultBundleAssetPath);
        if (assetInDevBundleUrl == null) {
            String assetInDevBundle = "/assets/" + assetPath;
            assetInDevBundleUrl = DevBundleUtils.findBundleFile(projectFolder, assetInDevBundle);
        }
        if (assetInDevBundleUrl == null) {
            String assetName = assetPath.substring(assetPath.indexOf(themeName) + themeName.length());
            throw new IllegalStateException(String.format("Asset '%1$s' is not found in project frontend directory, default development bundle or in the application bundle '%2$s/assets/'. \nVerify that the asset is available in 'frontend/themes/%3$s/' directory and is added into the 'assets' block of the 'theme.json' file.", assetName, "src/main/dev-bundle", themeName));
        }
        return assetInDevBundleUrl;
    }

    protected URL getStaticResource(String path) {
        return this.vaadinService.getStaticResource(path);
    }

    private boolean shouldFixIncorrectWebjarPaths() {
        return this.deploymentConfiguration.isProductionMode() && this.deploymentConfiguration.getBooleanProperty(PROPERTY_FIX_INCORRECT_WEBJAR_PATHS, false);
    }

    private boolean isIncorrectWebjarPath(String requestFilename) {
        return INCORRECT_WEBJAR_PATH_REGEX.matcher(requestFilename).lookingAt();
    }

    private String fixIncorrectWebjarPath(String requestFilename) {
        return INCORRECT_WEBJAR_PATH_REGEX.matcher(requestFilename).replaceAll("/webjars/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long writeModificationTimestamp(URL resourceUrl, HttpServletRequest request, HttpServletResponse response) {
        URLConnection connection = null;
        try {
            connection = resourceUrl.openConnection();
            long lastModifiedTime = connection.getLastModified();
            lastModifiedTime -= lastModifiedTime % 1000L;
            response.setDateHeader("Last-Modified", lastModifiedTime);
            long l = lastModifiedTime;
            return l;
        }
        catch (Exception e) {
            StaticFileServer.getLogger().trace("Failed to find out last modified timestamp. Continuing without it.", (Throwable)e);
        }
        finally {
            try {
                InputStream is;
                if (connection != null && (is = connection.getInputStream()) != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                StaticFileServer.getLogger().warn("Error closing URLConnection input stream", (Throwable)e);
            }
        }
        return -1L;
    }

    protected void writeCacheHeaders(String filenameWithPath, HttpServletResponse response) {
        int resourceCacheTime = this.getCacheTime(filenameWithPath);
        Object cacheControl = !this.deploymentConfiguration.isProductionMode() ? "no-cache" : (resourceCacheTime > 0 ? "max-age=" + resourceCacheTime : "public, max-age=0, must-revalidate");
        response.setHeader("Cache-Control", (String)cacheControl);
    }

    String getRequestFilename(HttpServletRequest request) {
        if (request.getPathInfo() == null) {
            return request.getServletPath();
        }
        if (request.getPathInfo().startsWith("/VAADIN/") || APP_THEME_ASSETS_PATTERN.matcher(request.getPathInfo()).find() || request.getPathInfo().startsWith("/sw.js")) {
            return request.getPathInfo();
        }
        return request.getServletPath() + request.getPathInfo();
    }

    protected int getCacheTime(String filenameWithPath) {
        if (filenameWithPath.contains(".nocache.")) {
            return 0;
        }
        if (filenameWithPath.contains(".cache.")) {
            return 31536000;
        }
        return 3600;
    }

    protected boolean browserHasNewestVersion(HttpServletRequest request, long resourceLastModifiedTimestamp) {
        assert (resourceLastModifiedTimestamp >= -1L);
        if (resourceLastModifiedTimestamp == -1L) {
            return false;
        }
        try {
            long headerIfModifiedSince = request.getDateHeader("If-Modified-Since");
            if (headerIfModifiedSince >= resourceLastModifiedTimestamp) {
                return true;
            }
        }
        catch (Exception e) {
            StaticFileServer.getLogger().trace("Unable to parse If-Modified-Since", (Throwable)e);
        }
        return false;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StaticFileServer.class.getName());
    }
}

