/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskClientGenerator
implements FallibleCommand {
    protected abstract String getFileContent() throws IOException;

    protected abstract File getGeneratedFile();

    protected abstract boolean shouldGenerate();

    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.shouldGenerate()) {
            return;
        }
        File generatedFile = this.getGeneratedFile();
        try {
            String fileContent = this.getFileContent();
            this.log().debug("writing file '{}'", (Object)generatedFile);
            FileUtils.forceMkdirParent((File)generatedFile);
            FileUtils.writeStringToFile((File)generatedFile, (String)fileContent, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", generatedFile);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

