/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jsoup.nodes.Element;

public class PwaIcon
implements Serializable {
    private final boolean shouldBeCached;
    private final int width;
    private final int height;
    private long fileHash;
    private String baseName;
    private Domain domain;
    private byte[] data;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String tag = "link";

    PwaIcon(int width, int height, String baseName) {
        this(width, height, baseName, Domain.HEADER);
    }

    PwaIcon(int width, int height, String baseName, Domain domain) {
        this(width, height, baseName, domain, false);
    }

    PwaIcon(int width, int height, String baseName, Domain domain, boolean shouldBeCached) {
        this(width, height, baseName, domain, shouldBeCached, "icon", "");
    }

    PwaIcon(int width, int height, String baseName, Domain domain, boolean shouldBeCached, String rel, String media) {
        this.width = width;
        this.height = height;
        this.baseName = baseName;
        this.domain = domain;
        this.shouldBeCached = shouldBeCached;
        this.attributes.put("type", "image/png");
        this.attributes.put("rel", rel);
        this.attributes.put("sizes", width + "x" + height);
        if (media != null && !media.isEmpty()) {
            this.attributes.put("media", media);
        }
        this.setRelativeName();
    }

    public Element asElement() {
        Element element = new Element(this.tag);
        this.attributes.forEach((arg_0, arg_1) -> ((Element)element).attr(arg_0, arg_1));
        return element;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean shouldBeCached() {
        return this.shouldBeCached;
    }

    private void setRelativeName() {
        int split = this.baseName.lastIndexOf(46);
        String link = this.baseName.substring(0, split) + "-" + this.getSizes() + this.baseName.substring(split);
        if (!this.shouldBeCached) {
            link = link + "?" + this.fileHash;
        }
        this.attributes.put("href", link);
    }

    public String getSizes() {
        return this.attributes.get("sizes");
    }

    public String getHref() {
        return this.attributes.get("href");
    }

    public String getRelHref() {
        String[] split = this.getHref().split("\\?");
        return "/" + split[0];
    }

    public String getCacheFormat() {
        return String.format("{ url: '%s', revision: '%s' }", this.getHref(), this.fileHash);
    }

    public String getType() {
        return this.attributes.get("type");
    }

    String getRel() {
        return this.attributes.get("rel");
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setImage(BufferedImage image) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", stream);
            stream.flush();
            this.data = stream.toByteArray();
            this.fileHash = Arrays.hashCode(this.data);
            this.setRelativeName();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to write an image ", ioe);
        }
    }

    public void write(OutputStream outputStream) {
        try {
            outputStream.write(this.data);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to store the icon image into the stream provided", ioe);
        }
    }

    public static enum Domain {
        HEADER,
        MANIFEST;

    }
}

