/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.frontend.AbstractUpdateImports;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class TaskUpdateImports
extends NodeUpdater {
    private static final String THEME_LINE_TPL = "%saddCssBlock('%s', true);";
    private static final String THEME_VARIANT_TPL = "document.documentElement.setAttribute('%s', '%s');";
    private static final Pattern NEW_LINE_TRIM = Pattern.compile("(?m)(^\\s+|\\s?\n)");
    private final File frontendDirectory;
    private final FrontendDependenciesScanner fallbackScanner;
    private final File tokenFile;
    private final JsonObject tokenFileData;
    private final boolean enablePnpm;
    private final boolean productionMode;
    private final boolean useLegacyV14Bootstrap;

    TaskUpdateImports(ClassFinder finder, FrontendDependenciesScanner frontendDepScanner, SerializableFunction<ClassFinder, FrontendDependenciesScanner> fallBackScannerProvider, File npmFolder, File generatedPath, File frontendDirectory, File tokenFile, JsonObject tokenFileData, boolean enablePnpm, String buildDir, boolean productionMode, boolean useLegacyV14Bootstrap, FeatureFlags featureFlags) {
        super(finder, frontendDepScanner, npmFolder, generatedPath, null, buildDir, featureFlags);
        this.frontendDirectory = frontendDirectory;
        this.fallbackScanner = (FrontendDependenciesScanner)fallBackScannerProvider.apply(finder);
        this.tokenFile = tokenFile;
        this.tokenFileData = tokenFileData;
        this.enablePnpm = enablePnpm;
        this.productionMode = productionMode;
        this.useLegacyV14Bootstrap = useLegacyV14Bootstrap;
    }

    @Override
    public void execute() {
        File fallBack = null;
        if (this.fallbackScanner != null) {
            UpdateFallBackImportsFile fallBackUpdate = new UpdateFallBackImportsFile(this.finder, this.frontendDirectory, this.npmFolder, this.generatedFolder, this.tokenFile, this.productionMode, this.useLegacyV14Bootstrap);
            fallBackUpdate.run();
            fallBack = fallBackUpdate.getGeneratedFallbackFile();
            this.updateBuildFile(fallBackUpdate);
        }
        UpdateMainImportsFile mainUpdate = new UpdateMainImportsFile(this.finder, this.frontendDirectory, this.npmFolder, this.generatedFolder, fallBack, this.tokenFile, this.productionMode, this.useLegacyV14Bootstrap);
        mainUpdate.run();
    }

    private ThemeDefinition getThemeDefinition() {
        ThemeDefinition def = this.frontDeps.getThemeDefinition();
        if (def != null) {
            return def;
        }
        if (this.fallbackScanner == null) {
            return null;
        }
        def = this.fallbackScanner.getThemeDefinition();
        if (def != null && this.log().isDebugEnabled()) {
            this.log().debug("Theme definition is discovered by the fallback scanner and not discovered by the main scanner. Theme '{}' will be used", (Object)def.getTheme().getName());
        }
        return def;
    }

    private AbstractTheme getTheme() {
        AbstractTheme theme = this.frontDeps.getTheme();
        if (theme != null) {
            return theme;
        }
        if (this.fallbackScanner == null) {
            return null;
        }
        return this.fallbackScanner.getTheme();
    }

    private void updateBuildFile(AbstractUpdateImports updater) {
        boolean tokenFileExists;
        boolean bl = tokenFileExists = this.tokenFile != null && this.tokenFile.exists();
        if (!tokenFileExists) {
            this.log().warn("Token file is not available. Fallback chunk data won't be written.");
        }
        try {
            if (tokenFileExists) {
                String json = FileUtils.readFileToString((File)this.tokenFile, (Charset)StandardCharsets.UTF_8);
                JsonObject buildInfo = json.isEmpty() ? Json.createObject() : (JsonObject)JsonUtil.parse((String)json);
                this.populateFallbackData(buildInfo, updater);
                FileUtils.write((File)this.tokenFile, (CharSequence)JsonUtil.stringify((JsonValue)buildInfo, (int)2), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            this.log().warn("Unable to read token file", (Throwable)e);
        }
        if (this.tokenFileData != null) {
            this.populateFallbackData(this.tokenFileData, updater);
        }
    }

    private void populateFallbackData(JsonObject object, AbstractUpdateImports updater) {
        JsonObject fallback = Json.createObject();
        fallback.put("jsModules", (JsonValue)this.makeFallbackModules(updater));
        fallback.put("cssImports", (JsonValue)this.makeFallbackCssImports(updater));
        JsonObject chunks = Json.createObject();
        chunks.put("fallback", (JsonValue)fallback);
        object.put("chunks", (JsonValue)chunks);
    }

    private JsonArray makeFallbackModules(AbstractUpdateImports updater) {
        JsonArray array = Json.createArray();
        List<String> modules = updater.getModules();
        Set<String> scripts = updater.getScripts();
        Iterator<String> modulesIterator = modules.iterator();
        Iterator<String> scriptsIterator = scripts.iterator();
        for (int i = 0; i < modules.size() + scripts.size(); ++i) {
            if (i < modules.size()) {
                array.set(i, modulesIterator.next());
                continue;
            }
            array.set(i, scriptsIterator.next());
        }
        return array;
    }

    private JsonArray makeFallbackCssImports(AbstractUpdateImports updater) {
        JsonArray array = Json.createArray();
        Set<CssData> css = updater.getCss();
        Iterator<CssData> iterator = css.iterator();
        for (int i = 0; i < css.size(); ++i) {
            array.set(i, (JsonValue)this.makeCssJson(iterator.next()));
        }
        return array;
    }

    private JsonObject makeCssJson(CssData data) {
        JsonObject object = Json.createObject();
        if (data.getId() != null) {
            object.put("id", data.getId());
        }
        if (data.getInclude() != null) {
            object.put("include", data.getInclude());
        }
        if (data.getThemefor() != null) {
            object.put("themeFor", data.getThemefor());
        }
        if (data.getValue() != null) {
            object.put("value", data.getValue());
        }
        return object;
    }

    private String getAbsentPackagesMessage() {
        String lockFile = this.enablePnpm ? "pnpm-lock.yaml" : "package-lock.json";
        String command = this.enablePnpm ? "pnpm" : "npm";
        String note = "";
        if (this.enablePnpm) {
            note = "\nMake sure first that `pnpm` command is installed, otherwise you should install it using npm: `npm add -g pnpm@5.18.10`";
        }
        return String.format("If the build fails, check that npm packages are installed.\n\n  To fix the build remove `%s` and `node_modules` directory to reset modules.\n  In addition you may run `%s install` to fix `node_modules` tree structure.%s", lockFile, command, note);
    }

    private class UpdateFallBackImportsFile
    extends AbstractUpdateImports {
        private final File generatedFallBack;
        private final ClassFinder finder;

        UpdateFallBackImportsFile(ClassFinder classFinder, File frontendDirectory, File npmDirectory, File generatedDirectory, File tokenFile, boolean productionMode, boolean useLegacyV14Bootstrap) {
            super(frontendDirectory, npmDirectory, generatedDirectory, tokenFile, productionMode, useLegacyV14Bootstrap);
            this.generatedFallBack = new File(generatedDirectory, "generated-flow-imports-fallback.js");
            this.finder = classFinder;
        }

        @Override
        protected void writeImportLines(List<String> lines) {
            try {
                this.updateImportsFile(this.generatedFallBack, lines);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to update the Flow fallback imports file '%s'", this.getGeneratedFallbackFile()), e);
            }
        }

        @Override
        protected Collection<String> getThemeLines() {
            return Collections.emptyList();
        }

        @Override
        protected List<String> getModules() {
            LinkedHashSet<String> set = new LinkedHashSet<String>(TaskUpdateImports.this.fallbackScanner.getModules());
            set.removeAll(TaskUpdateImports.this.frontDeps.getModules());
            return new ArrayList<String>(set);
        }

        @Override
        protected Set<String> getScripts() {
            LinkedHashSet<String> set = new LinkedHashSet<String>(TaskUpdateImports.this.fallbackScanner.getScripts());
            set.removeAll(TaskUpdateImports.this.frontDeps.getScripts());
            return set;
        }

        @Override
        protected URL getResource(String name) {
            return this.finder.getResource(name);
        }

        @Override
        protected Collection<String> getGeneratedModules() {
            return Collections.emptyList();
        }

        @Override
        protected ThemeDefinition getThemeDefinition() {
            return TaskUpdateImports.this.getThemeDefinition();
        }

        @Override
        protected AbstractTheme getTheme() {
            return TaskUpdateImports.this.getTheme();
        }

        @Override
        protected Set<CssData> getCss() {
            LinkedHashSet<CssData> set = new LinkedHashSet<CssData>(TaskUpdateImports.this.fallbackScanner.getCss());
            set.removeAll(TaskUpdateImports.this.frontDeps.getCss());
            return set;
        }

        @Override
        protected Logger getLogger() {
            return TaskUpdateImports.this.log();
        }

        @Override
        protected String getImportsNotFoundMessage() {
            return TaskUpdateImports.this.getAbsentPackagesMessage();
        }

        @Override
        protected String getThemeIdPrefix() {
            return "fallback_" + super.getThemeIdPrefix();
        }

        File getGeneratedFallbackFile() {
            return this.generatedFallBack;
        }
    }

    private class UpdateMainImportsFile
    extends AbstractUpdateImports {
        private static final String EXPORT_MODULES_DEF = "export declare const addCssBlock: (block: string, before?: boolean) => void;";
        private final File generatedFlowImports;
        private final File generatedFlowDefinitions;
        private final File fallBackImports;
        private final ClassFinder finder;

        UpdateMainImportsFile(ClassFinder classFinder, File frontendDirectory, File npmDirectory, File generatedDirectory, File fallBackImports, File tokenFile, boolean productionMode, boolean useLegacyV14Bootstrap) {
            super(frontendDirectory, npmDirectory, generatedDirectory, tokenFile, productionMode, useLegacyV14Bootstrap);
            this.generatedFlowImports = new File(generatedDirectory, "generated-flow-imports.js");
            this.generatedFlowDefinitions = new File(generatedDirectory, "generated-flow-imports.d.ts");
            this.finder = classFinder;
            this.fallBackImports = fallBackImports;
        }

        @Override
        protected void writeImportLines(List<String> lines) {
            if (this.fallBackImports != null) {
                lines.add("let thisScript;");
                lines.add("const elements = document.getElementsByTagName('script');");
                lines.add("for (let i = 0; i < elements.length; i++) {");
                lines.add(" const script = elements[i];");
                lines.add(" if (script.getAttribute('type')=='module' && script.getAttribute('data-app-id') && !script['vaadin-bundle']) {");
                lines.add("  thisScript = script;");
                lines.add("  break;");
                lines.add(" }");
                lines.add("}");
                lines.add("if (!thisScript) {");
                lines.add(" throw new Error('Could not find the bundle script to identify the application id');");
                lines.add("}");
                lines.add("thisScript['vaadin-bundle'] = true;");
                lines.add("if (!window.Vaadin.Flow.fallbacks) { window.Vaadin.Flow.fallbacks={}; }");
                lines.add("const fallbacks = window.Vaadin.Flow.fallbacks;");
                lines.add("fallbacks[thisScript.getAttribute('data-app-id')] = {}");
                lines.add("fallbacks[thisScript.getAttribute('data-app-id')].loadFallback = function loadFallback() {");
                lines.add(" return import('./" + this.fallBackImports.getName() + "');");
                lines.add("}");
            }
            try {
                this.updateImportsFile(this.generatedFlowImports, lines);
                this.updateImportsFile(this.generatedFlowDefinitions, this.getDefinitionLines());
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to update the Flow imports file '%s'", this.generatedFlowImports), e);
            }
        }

        @Override
        protected Collection<String> getThemeLines() {
            ArrayList<String> lines = new ArrayList<String>();
            AbstractTheme theme = this.getTheme();
            ThemeDefinition themeDef = this.getThemeDefinition();
            if (theme != null) {
                boolean hasApplicationTheme;
                boolean bl = hasApplicationTheme = themeDef != null && !"".equals(themeDef.getName());
                if (this.useLegacyV14Bootstrap && hasApplicationTheme) {
                    lines.add("import {applyTheme} from 'generated/theme.js';");
                    lines.add("if (window.Vaadin.theme.flowBootstrap) {");
                    lines.add("  applyTheme(document);");
                    lines.add("}");
                }
                if (!theme.getHeaderInlineContents().isEmpty()) {
                    lines.add("");
                    if (hasApplicationTheme) {
                        lines.add("// Handled in the application theme");
                    }
                    theme.getHeaderInlineContents().forEach(html -> this.addLines(lines, String.format(TaskUpdateImports.THEME_LINE_TPL, hasApplicationTheme ? "// " : "", NEW_LINE_TRIM.matcher((CharSequence)html).replaceAll(""))));
                }
                if (themeDef != null) {
                    theme.getHtmlAttributes(themeDef.getVariant()).forEach((key, value) -> this.addLines(lines, String.format(TaskUpdateImports.THEME_VARIANT_TPL, key, value)));
                }
                lines.add("");
            }
            return lines;
        }

        @Override
        protected List<String> getModules() {
            return TaskUpdateImports.this.frontDeps.getModules();
        }

        @Override
        protected Set<String> getScripts() {
            return TaskUpdateImports.this.frontDeps.getScripts();
        }

        @Override
        protected URL getResource(String name) {
            return this.finder.getResource(name);
        }

        @Override
        protected Collection<String> getGeneratedModules() {
            HashSet<String> exclude = new HashSet<String>(Arrays.asList(this.generatedFlowImports.getName(), "generated-flow-imports-fallback.js"));
            return NodeUpdater.getGeneratedModules(TaskUpdateImports.this.generatedFolder, exclude);
        }

        @Override
        protected ThemeDefinition getThemeDefinition() {
            return TaskUpdateImports.this.getThemeDefinition();
        }

        @Override
        protected AbstractTheme getTheme() {
            return TaskUpdateImports.this.getTheme();
        }

        @Override
        protected Set<CssData> getCss() {
            return TaskUpdateImports.this.frontDeps.getCss();
        }

        @Override
        protected Logger getLogger() {
            return TaskUpdateImports.this.log();
        }

        @Override
        protected String getImportsNotFoundMessage() {
            return TaskUpdateImports.this.getAbsentPackagesMessage();
        }

        protected List<String> getDefinitionLines() {
            ArrayList<String> lines = new ArrayList<String>();
            this.addLines(lines, EXPORT_MODULES_DEF);
            return lines;
        }
    }
}

