/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import java.io.File;
import java.util.ArrayList;

public class TaskGenerateFeatureFlags
extends AbstractTaskClientGenerator {
    private final File frontendGeneratedDirectory;
    private final FeatureFlags featureFlags;

    TaskGenerateFeatureFlags(File frontendDirectory, FeatureFlags featureFlags) {
        this.frontendGeneratedDirectory = new File(frontendDirectory, "generated/");
        this.featureFlags = featureFlags;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("// @ts-nocheck");
        lines.add("window.Vaadin = window.Vaadin || {};");
        lines.add("window.Vaadin.featureFlags = window.Vaadin.featureFlags || {};");
        this.featureFlags.getFeatures().forEach(feature -> lines.add(String.format("window.Vaadin.featureFlags.%s = %s;", feature.getId(), this.featureFlags.isEnabled((Feature)feature))));
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.frontendGeneratedDirectory, "vaadin-featureflags.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

