/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.BootstrapHandlerHelper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.internal.UsageStatisticsExporter;
import com.vaadin.flow.internal.springcsrf.SpringCsrfTokenUtil;
import com.vaadin.flow.server.AppShellRegistry;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.flow.server.communication.JavaScriptBootstrapHandler;
import com.vaadin.flow.server.frontend.FrontendUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHtmlRequestHandler
extends JavaScriptBootstrapHandler {
    private static final String SCRIPT = "script";
    private static final String SCRIPT_INITIAL = "initial";

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        IndexHtmlResponse indexHtmlResponse;
        if (this.writeErrorCodeIfRequestLocationIsInvalid(request, response)) {
            return true;
        }
        DeploymentConfiguration config = session.getConfiguration();
        VaadinService service = request.getService();
        Document indexDocument = config.isProductionMode() ? IndexHtmlRequestHandler.getCachedIndexHtmlDocument(service) : IndexHtmlRequestHandler.getIndexHtmlDocument(service);
        IndexHtmlRequestHandler.prependBaseHref(request, indexDocument);
        JsonObject initialJson = Json.createObject();
        if (service.getBootstrapInitialPredicate().includeInitialUidl(request)) {
            this.includeInitialUidl(initialJson, session, request, response);
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument, UI.getCurrent());
            session.setAttribute("clientRoutingMode", Boolean.TRUE);
        } else {
            indexHtmlResponse = new IndexHtmlResponse(request, response, indexDocument);
        }
        this.addInitialFlow(initialJson, indexDocument, request);
        this.configureErrorDialogStyles(indexDocument);
        IndexHtmlRequestHandler.showWebpackErrors(session.getService(), indexDocument);
        response.setContentType("text/html; charset=utf-8");
        VaadinContext context = session.getService().getContext();
        AppShellRegistry registry = AppShellRegistry.getInstance(context);
        if (!config.isProductionMode()) {
            UsageStatisticsExporter.exportUsageStatisticsToDocument(indexDocument);
        }
        if (!FeatureFlags.get(service.getContext()).isEnabled(FeatureFlags.VITE) || config.isProductionMode()) {
            IndexHtmlRequestHandler.setupPwa(indexDocument, session.getService());
        }
        registry.modifyIndexHtml(indexDocument, request);
        this.storeAppShellTitleToUI(indexDocument);
        service.modifyIndexHtmlResponse(indexHtmlResponse);
        if (config.isDevModeGizmoEnabled()) {
            this.addDevmodeGizmo(indexDocument, config, session, request);
            this.catchErrorsInDevMode(indexDocument);
        }
        try {
            response.getOutputStream().write(indexDocument.html().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            IndexHtmlRequestHandler.getLogger().error("Error writing 'index.html' to response", (Throwable)e);
            return false;
        }
        return true;
    }

    private void catchErrorsInDevMode(Document indexDocument) {
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.appendChild((Node)new DataNode("window.Vaadin = window.Vaadin || {};window.Vaadin.ConsoleErrors = window.Vaadin.ConsoleErrors || [];const browserConsoleError = window.console.error.bind(window.console);console.error = (...args) => {    browserConsoleError(...args);    window.Vaadin.ConsoleErrors.push(args);};window.onerror = (message, source, lineno, colno, error) => {const location=source+':'+lineno+':'+colno;window.Vaadin.ConsoleErrors.push([message, '('+location+')']);};window.addEventListener('unhandledrejection', e => {    window.Vaadin.ConsoleErrors.push([e.reason]);});"));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void storeAppShellTitleToUI(Document indexDocument) {
        Element elm;
        if (UI.getCurrent() != null && (elm = indexDocument.head().selectFirst("title")) != null) {
            String appShellTitle = elm.text().isEmpty() ? elm.data() : elm.text();
            UI.getCurrent().getInternals().setAppShellTitle(appShellTitle);
        }
    }

    private void addDevmodeGizmo(Document indexDocument, DeploymentConfiguration config, VaadinSession session, VaadinRequest request) {
        VaadinService service = session.getService();
        Optional<BrowserLiveReload> liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(service);
        if (liveReload.isPresent()) {
            Element devmodeGizmo = new Element("vaadin-devmode-gizmo");
            if (!config.isDevModeLiveReloadEnabled()) {
                devmodeGizmo.attr("liveReloadDisabled", "");
            }
            devmodeGizmo.attr("url", BootstrapHandlerHelper.getPushURL(session, request));
            BrowserLiveReload.Backend backend = liveReload.get().getBackend();
            if (backend != null) {
                devmodeGizmo.attr("backend", backend.toString());
            }
            devmodeGizmo.attr("springbootlivereloadport", Integer.toString(35729));
            indexDocument.body().appendChild((Node)devmodeGizmo);
        }
    }

    private void addInitialFlow(JsonObject initialJson, Document indexDocument, VaadinRequest request) {
        SpringCsrfTokenUtil.addTokenAsMetaTagsToHeadIfPresentInRequest(indexDocument.head(), request);
        Element elm = new Element(SCRIPT);
        elm.attr(SCRIPT_INITIAL, "");
        elm.appendChild((Node)new DataNode("window.Vaadin = window.Vaadin || {};window.Vaadin.TypeScript= " + JsonUtil.stringify((JsonValue)initialJson) + ";"));
        indexDocument.head().insertChildren(0, new Node[]{elm});
    }

    private void includeInitialUidl(JsonObject initialJson, VaadinSession session, VaadinRequest request, VaadinResponse response) {
        JsonObject initial = this.getInitialJson(request, response, session);
        initialJson.put(SCRIPT_INITIAL, (JsonValue)initial);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return this.isRequestForHtml(request) && !BootstrapHandler.isFrameworkInternalRequest(request) && !BootstrapHandler.isVaadinStaticFileRequest(request) && request.getService().getBootstrapUrlPredicate().isValidUrl(request);
    }

    @Override
    protected void initializeUIWithRouter(BootstrapHandler.BootstrapContext context, UI ui) {
        if (context.getService().getBootstrapInitialPredicate().includeInitialUidl(context.getRequest())) {
            ui.getInternals().getRouter().initializeUI(ui, context.getRoute());
        }
    }

    private void configureErrorDialogStyles(Document document) {
        Element styles = document.createElement("style");
        document.head().appendChild((Node)styles);
        IndexHtmlRequestHandler.setupErrorDialogs(styles);
    }

    private static void prependBaseHref(VaadinRequest request, Document indexDocument) {
        Elements base = indexDocument.head().getElementsByTag("base");
        String baseHref = IndexHtmlRequestHandler.getServiceUrl(request);
        if (base.isEmpty()) {
            indexDocument.head().prependElement("base").attr("href", baseHref);
        } else {
            base.first().attr("href", baseHref);
        }
    }

    private static Document getCachedIndexHtmlDocument(VaadinService service) {
        return service.getContext().getAttribute(IndexHtmlHolder.class, () -> new IndexHtmlHolder(service)).getDocument();
    }

    private static Document getIndexHtmlDocument(VaadinService service) throws IOException {
        String index = FrontendUtils.getIndexHtmlContent(service);
        if (index != null) {
            Document indexHtmlDocument = Jsoup.parse((String)index);
            if (FeatureFlags.get(service.getContext()).isEnabled(FeatureFlags.VITE)) {
                IndexHtmlRequestHandler.modifyIndexHtmlForVite(indexHtmlDocument);
            }
            return indexHtmlDocument;
        }
        String frontendDir = FrontendUtils.getProjectFrontendDir(service.getDeploymentConfiguration());
        String indexHtmlFilePath = frontendDir.endsWith("/") || frontendDir.endsWith(File.separator) ? frontendDir + "index.html" : (frontendDir.contains(File.separator) ? frontendDir + File.separatorChar + "index.html" : frontendDir + "/index.html");
        String message = String.format("Failed to load content of '%1$s'. It is required to have '%1$s' file when using client side bootstrapping.", indexHtmlFilePath);
        throw new IOException(message);
    }

    private static void modifyIndexHtmlForVite(Document indexHtmlDocument) {
        indexHtmlDocument.head().prepend("<script type='text/javascript'>window.JSCompiler_renameProperty = function(a) { return a;}</script>");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(IndexHtmlRequestHandler.class);
    }

    private static final class IndexHtmlHolder
    implements Serializable {
        private final transient Document indexHtmlDocument;

        private IndexHtmlHolder(VaadinService service) {
            try {
                this.indexHtmlDocument = IndexHtmlRequestHandler.getIndexHtmlDocument(service);
                this.indexHtmlDocument.outputSettings().prettyPrint(false);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private Document getDocument() {
            return this.indexHtmlDocument.clone();
        }
    }
}

